/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.scenelib.type;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import org.checkerframework.afu.scenelib.type.Type;

public class DeclaredType
extends Type {
    public static final String WILDCARD = "?";
    private String name;
    private List<Type> typeParameters;
    private DeclaredType innerType;

    public DeclaredType(String name) {
        this.name = name;
        this.typeParameters = new ArrayList<Type>();
        this.innerType = null;
    }

    public DeclaredType() {
        this("");
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addTypeParameter(Type typeParameter) {
        this.checkWildcard();
        this.typeParameters.add(typeParameter);
    }

    public void setTypeParameters(List<Type> typeParameters) {
        this.checkWildcard();
        this.typeParameters = typeParameters;
    }

    public Type getTypeParameter(int index) {
        this.checkWildcard();
        return this.typeParameters.get(index);
    }

    public List<Type> getTypeParameters() {
        this.checkWildcard();
        return new ArrayList<Type>(this.typeParameters);
    }

    public void setInnerType(DeclaredType innerType) {
        this.checkWildcard();
        this.innerType = innerType;
    }

    public DeclaredType getInnerType() {
        this.checkWildcard();
        return this.innerType;
    }

    @Override
    public Type.Kind getKind() {
        return Type.Kind.DECLARED;
    }

    public boolean isWildcard() {
        return WILDCARD.equals(this.name);
    }

    private void checkWildcard() {
        if (this.isWildcard()) {
            throw new IllegalStateException("This method can't be called since this DeclaredType is a wildcard.");
        }
    }

    public String toString() {
        StringJoiner result = new StringJoiner(", ", "DeclaredType[", "]");
        result.add("name=" + this.name);
        if (!this.typeParameters.isEmpty()) {
            result.add("typeParameters=" + this.typeParameters);
        }
        if (this.innerType != null) {
            result.add("innerType=" + this.innerType);
        }
        return result.toString();
    }
}

