/*
 * Copyright (c) 1996, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package java.sql;

import org.checkerframework.checker.interning.qual.UsesObjectEquals;
import org.checkerframework.framework.qual.AnnotatedFor;

@AnnotatedFor({ "interning" })
@UsesObjectEquals
public class Types {

    public static final int BIT;

    public static final int TINYINT;

    public static final int SMALLINT;

    public static final int INTEGER;

    public static final int BIGINT;

    public static final int FLOAT;

    public static final int REAL;

    public static final int DOUBLE;

    public static final int NUMERIC;

    public static final int DECIMAL;

    public static final int CHAR;

    public static final int VARCHAR;

    public static final int LONGVARCHAR;

    public static final int DATE;

    public static final int TIME;

    public static final int TIMESTAMP;

    public static final int BINARY;

    public static final int VARBINARY;

    public static final int LONGVARBINARY;

    public static final int NULL;

    public static final int OTHER;

    public static final int JAVA_OBJECT;

    public static final int DISTINCT;

    public static final int STRUCT;

    public static final int ARRAY;

    public static final int BLOB;

    public static final int CLOB;

    public static final int REF;

    public static final int DATALINK;

    public static final int BOOLEAN;

    public static final int ROWID;

    public static final int NCHAR;

    public static final int NVARCHAR;

    public static final int LONGNVARCHAR;

    public static final int NCLOB;

    public static final int SQLXML;

    public static final int REF_CURSOR;

    public static final int TIME_WITH_TIMEZONE;

    public static final int TIMESTAMP_WITH_TIMEZONE;
}
