/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.scenelib.io.classfile;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.checkerframework.afu.scenelib.el.AScene;
import org.checkerframework.afu.scenelib.io.IndexFileParser;
import org.checkerframework.afu.scenelib.io.classfile.ClassAnnotationSceneWriter;
import org.checkerframework.afu.scenelib.io.classfile.ClassFileReader;
import org.checkerframework.afu.scenelib.util.CommandLineUtils;
import org.objectweb.asm.ClassReader;
import org.plumelib.options.Option;
import org.plumelib.options.Options;

public class ClassFileWriter {
    @Option(value="-h print usage information and exit")
    public static boolean help = false;
    @Option(value="print version information and exit")
    public static boolean version = false;
    @Option(value="print progress messages")
    public static boolean verbose = false;
    private static String linesep = System.getProperty("line.separator");
    static String usage = "usage: insert-annotations [options] class1 indexfile1 class2 indexfile2 ..." + linesep + "For each class/index file pair (a.second.C a.second.C.jaif), read annotations from" + linesep + "the index file a.second.C.jaif and insert them into the class a.second.C, then" + linesep + "output the merged class file to a.second.C.class" + linesep + "Each class is either a fully-qualified name of a class on your classpath," + linesep + "or a path to a .class file, such as e.g. /.../path/to/a/b/C.class ." + linesep + "Arguments beginning with a single '@' are interpreted as argument files to" + linesep + "be read and expanded into the command line.  Options:";

    public static void main(String[] args) throws IOException {
        int i;
        String[] file_args;
        Options options = new Options(usage, ClassFileWriter.class);
        try {
            String[] cl_args = CommandLineUtils.parseCommandLine(args);
            file_args = options.parse(true, cl_args);
        }
        catch (Exception ex) {
            System.err.println(ex);
            System.err.println("(For non-argfile beginning with \"@\", use \"@@\" for initial \"@\".");
            System.err.println("Alternative for filenames: indicate directory, e.g. as './@file'.");
            System.err.println("Alternative for flags: use '=', as in '-o=@Deprecated'.)");
            System.exit(1);
            throw new Error("unreachable");
        }
        if (version) {
            System.out.printf("insert-annotations (%s)", "Annotation File Utilities v3.9.14");
        }
        if (help) {
            options.printUsage();
        }
        if (version || help) {
            System.exit(-1);
        }
        if (file_args.length == 0) {
            System.out.println("No arguments given.");
            options.printUsage();
            System.exit(-1);
        }
        if (file_args.length % 2 == 1) {
            System.out.println("Must supply an even number of arguments.");
            options.printUsage();
            System.exit(-1);
        }
        for (i = 0; i < file_args.length; i += 2) {
            if (ClassFileReader.checkClass(file_args[i])) continue;
            System.exit(-1);
        }
        for (i = 0; i < file_args.length; ++i) {
            String className = file_args[i];
            if (++i >= file_args.length) {
                System.out.println("Error: incorrect number of arguments");
                System.out.println("Run insert-annotations --help for usage information");
                return;
            }
            String indexFileName = file_args[i];
            AScene scene = new AScene();
            IndexFileParser.parseFile(indexFileName, scene);
            try {
                if (className.endsWith(".class")) {
                    String fileName = className;
                    if (verbose) {
                        System.out.printf("Adding annotations to class file %s%n", fileName);
                    }
                    ClassFileWriter.insert(scene, fileName, true);
                    continue;
                }
                String outputFileName = className + ".class";
                if (verbose) {
                    System.out.printf("Reading class file %s; writing with annotations to %s%n", className, outputFileName);
                }
                ClassFileWriter.insert(scene, className, outputFileName, true);
                continue;
            }
            catch (IOException e) {
                System.out.printf("IOException: %s%n", e.getMessage());
                return;
            }
            catch (Exception e) {
                System.out.println("Unknown error trying to insert annotations from: " + indexFileName + " to " + className);
                e.printStackTrace();
                System.out.flush();
                System.out.println("Please submit a bug report at");
                System.out.println("  https://github.com/typetools/checker-framework/issues");
                System.out.println("Be sure to include a copy of the following output trace, instructions on how");
                System.out.println("to reproduce this error, and all input files.  Thanks!");
                return;
            }
        }
    }

    public static void insert(AScene scene, String fileName, boolean overwrite) throws IOException {
        ClassReader classReader;
        assert (fileName.endsWith(".class"));
        try (FileInputStream in = new FileInputStream(fileName);){
            classReader = new ClassReader(in);
        }
        ClassAnnotationSceneWriter classAnnotationSceneWriter = new ClassAnnotationSceneWriter(524288, classReader, scene, overwrite);
        classReader.accept(classAnnotationSceneWriter, 0);
        try (FileOutputStream fos = new FileOutputStream(fileName);){
            ((OutputStream)fos).write(classAnnotationSceneWriter.toByteArray());
        }
    }

    public static void insert(AScene scene, InputStream input, OutputStream out, boolean overwrite) throws IOException {
        ClassReader classReader = new ClassReader(input);
        ClassAnnotationSceneWriter classAnnotationSceneWriter = new ClassAnnotationSceneWriter(524288, classReader, scene, overwrite);
        classReader.accept(classAnnotationSceneWriter, 0);
        out.write(classAnnotationSceneWriter.toByteArray());
    }

    public static void insert(AScene scene, String className, String outputFileName, boolean overwrite) throws IOException {
        ClassReader classReader = new ClassReader(className);
        ClassAnnotationSceneWriter classAnnotationSceneWriter = new ClassAnnotationSceneWriter(524288, classReader, scene, overwrite);
        classReader.accept(classAnnotationSceneWriter, 0);
        try (FileOutputStream fos = new FileOutputStream(outputFileName);){
            ((OutputStream)fos).write(classAnnotationSceneWriter.toByteArray());
        }
    }
}

