/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.annotator.find;

import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import org.checkerframework.afu.annotator.find.Criteria;
import org.checkerframework.afu.annotator.find.Criterion;
import org.checkerframework.afu.annotator.scanner.LambdaScanner;
import org.checkerframework.afu.scenelib.el.RelativeLocation;
import org.checkerframework.checker.interning.qual.FindDistinct;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LambdaCriterion
implements Criterion {
    private final String methodName;
    private final RelativeLocation loc;

    public LambdaCriterion(String methodName, RelativeLocation loc) {
        this.methodName = methodName;
        this.loc = loc;
    }

    @Override
    public boolean isSatisfiedBy(@Nullable TreePath path, @FindDistinct Tree leaf) {
        if (path == null) {
            return false;
        }
        assert (path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(@Nullable TreePath path) {
        if (path == null) {
            Criteria.dbug.debug("return null", new Object[0]);
            return false;
        }
        Tree leaf = path.getLeaf();
        Criteria.dbug.debug("%n%s%n", this.toString());
        Criteria.dbug.debug("LambdaCriterion.isSatisfiedBy: %s%n", leaf);
        Criteria.dbug.debug("leaf: %s%n", leaf);
        Criteria.dbug.debug("kind: %s%n", new Object[]{leaf.getKind()});
        Criteria.dbug.debug("class: %s%n", leaf.getClass());
        TreePath parentPath = path.getParentPath();
        if (parentPath == null) {
            Criteria.dbug.debug("return: parent path null%n", new Object[0]);
            return false;
        }
        Tree parent = parentPath.getLeaf();
        if (parent == null) {
            Criteria.dbug.debug("return: parent null%n", new Object[0]);
            return false;
        }
        if (parent instanceof LambdaExpressionTree) {
            boolean b;
            int indexInSource = LambdaScanner.indexOfLambdaExpressionTree(path, parent);
            Criteria.dbug.debug("return source: %d%n", indexInSource);
            if (this.loc.isBytecodeOffset()) {
                int indexInClass = LambdaScanner.getMethodLambdaExpressionIndex(this.methodName, this.loc.offset);
                Criteria.dbug.debug("return class: %d%n", indexInClass);
                b = indexInSource == indexInClass;
            } else {
                b = indexInSource == this.loc.index;
                Criteria.dbug.debug("return loc.index: %d%n", this.loc.index);
            }
            Criteria.dbug.debug("return new: %b%n", b);
            return b;
        }
        boolean b = this.isSatisfiedBy(path.getParentPath());
        Criteria.dbug.debug("return parent: %b%n", b);
        return b;
    }

    @Override
    public boolean isOnlyTypeAnnotationCriterion() {
        return false;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.LAMBDA_EXPRESSION;
    }

    public String toString() {
        return "LambdaCriterion: at location: " + this.loc;
    }
}

