/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.annotator.find;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.type.NullType;
import org.checkerframework.afu.annotator.Main;
import org.checkerframework.afu.annotator.find.AnnotationInsertion;
import org.checkerframework.afu.annotator.find.CastInsertion;
import org.checkerframework.afu.annotator.find.ConstructorInsertion;
import org.checkerframework.afu.annotator.find.Criteria;
import org.checkerframework.afu.annotator.find.GenericArrayLocationCriterion;
import org.checkerframework.afu.annotator.find.InClassCriterion;
import org.checkerframework.afu.annotator.find.Insertion;
import org.checkerframework.afu.annotator.find.Insertions;
import org.checkerframework.afu.annotator.find.NewInsertion;
import org.checkerframework.afu.annotator.find.ReceiverInsertion;
import org.checkerframework.afu.annotator.find.TypedInsertion;
import org.checkerframework.afu.annotator.scanner.TreePathUtil;
import org.checkerframework.afu.annotator.specification.IndexFileSpecification;
import org.checkerframework.afu.scenelib.el.AnnotationDef;
import org.checkerframework.afu.scenelib.el.TypePathEntry;
import org.checkerframework.afu.scenelib.io.ASTIndex;
import org.checkerframework.afu.scenelib.io.ASTPath;
import org.checkerframework.afu.scenelib.io.ASTRecord;
import org.checkerframework.afu.scenelib.io.DebugWriter;
import org.checkerframework.afu.scenelib.type.DeclaredType;
import org.checkerframework.afu.scenelib.type.Type;
import org.checkerframework.com.google.common.collect.LinkedHashMultimap;
import org.checkerframework.com.google.common.collect.Multimaps;
import org.checkerframework.com.google.common.collect.SetMultimap;
import org.checkerframework.org.plumelib.util.IPair;

public class TreeFinder
extends TreeScanner<Void, java.util.List<Insertion>> {
    public static final DebugWriter dbug = new DebugWriter(false);
    public static final DebugWriter warn = new DebugWriter(false);
    private static final String comment = "//.*$|/\\*[^*]*+\\*++(?:[^*/][^*]*+\\*++)*+/";
    private static final String literal = "'(?:(?:\\\\(?:'|[^']*+))|[^\\\\'])'|\"(?:\\\\.|[^\\\\\"])*\"";
    private static final String nonDelimSlash = "/(?=[^*/])";
    Map<Tree, TreePath> treePathCache = new HashMap<Tree, TreePath>();
    private final TypePositionFinder tpf;
    private final DeclarationPositionFinder dpf;
    private final JCTree.JCCompilationUnit tree;
    private final SetMultimap<IPair<Integer, ASTPath>, Insertion> insertions;
    private final SetMultimap<ASTRecord, Insertion> astInsertions;

    private static final String otherThan(char c) {
        String cEscaped;
        switch (c) {
            case '\"': 
            case '\'': 
            case '/': {
                cEscaped = "";
                break;
            }
            case '[': 
            case '\\': 
            case ']': {
                cEscaped = "\\" + c;
                break;
            }
            default: {
                cEscaped = "" + c;
            }
        }
        return "[^/'" + cEscaped + "\"]||" + literal + "|" + comment + (c == '/' ? "" : nonDelimSlash);
    }

    public static TreePath largestContainingArray(TreePath p) {
        if (!(p.getLeaf() instanceof ArrayTypeTree)) {
            return null;
        }
        while (p.getParentPath().getLeaf() instanceof ArrayTypeTree) {
            p = p.getParentPath();
        }
        assert (p.getLeaf() instanceof ArrayTypeTree);
        return p;
    }

    private int getFirstInstanceAfter(char c, int start) {
        return this.getNthInstanceInRange(c, start, Integer.MAX_VALUE, 1);
    }

    private int getNthInstanceInRange(char c, int start, int end, int n) {
        if (end < 0) {
            throw new IllegalArgumentException("negative end position");
        }
        if (n < 0) {
            throw new IllegalArgumentException("negative count");
        }
        try {
            CharSequence s = this.tree.getSourceFile().getCharContent(true);
            int count = n;
            int pos = -1;
            int stop = Math.min(end, s.length());
            String cQuoted = c == '/' ? nonDelimSlash : Pattern.quote("" + c);
            String regex = "(?:" + TreeFinder.otherThan(c) + ")*+" + cQuoted;
            Pattern p = Pattern.compile(regex, 8);
            Matcher m = p.matcher(s).region(start, stop);
            while (m.find()) {
                pos = m.end() - 1;
                if (--count != 0) continue;
            }
            return count > 0 ? -1 : pos;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Tree parent(Tree node) {
        TreePath parentPath = this.getPath(node).getParentPath();
        return parentPath == null ? null : parentPath.getLeaf();
    }

    public TreePath getPath(Tree target) {
        if (this.treePathCache.containsKey(target)) {
            return this.treePathCache.get(target);
        }
        TreePath result = TreePath.getPath(this.tree, target);
        this.treePathCache.put(target, result);
        return result;
    }

    private ASTRecord astRecord(Tree node) {
        Map<Tree, ASTRecord> index = ASTIndex.indexOf(this.tree);
        return index.get(node);
    }

    public TreeFinder(JCTree.JCCompilationUnit tree) {
        this.tree = tree;
        this.insertions = LinkedHashMultimap.create();
        this.astInsertions = LinkedHashMultimap.create();
        this.tpf = new TypePositionFinder();
        this.dpf = new DeclarationPositionFinder();
    }

    boolean handled(Tree node) {
        switch (node.getKind()) {
            case IDENTIFIER: 
            case PRIMITIVE_TYPE: 
            case ARRAY_TYPE: 
            case PARAMETERIZED_TYPE: 
            case EXTENDS_WILDCARD: 
            case SUPER_WILDCARD: 
            case UNBOUNDED_WILDCARD: 
            case ANNOTATION: 
            case CLASS: 
            case COMPILATION_UNIT: 
            case ENUM: 
            case EXPRESSION_STATEMENT: 
            case INTERFACE: 
            case METHOD: 
            case NEW_ARRAY: 
            case NEW_CLASS: 
            case TYPE_PARAMETER: 
            case VARIABLE: {
                return true;
            }
        }
        return node instanceof ExpressionTree;
    }

    private boolean wildcardLast(java.util.List<TypePathEntry> location) {
        return location.get((int)(location.size() - 1)).step == 2;
    }

    @Override
    public Void scan(Tree node, java.util.List<Insertion> p) {
        if (node == null || p.isEmpty()) {
            return null;
        }
        dbug.debug("TreeFinder.scan(kind=%s, %d insertions): %s%n", new Object[]{node.getKind(), p.size(), Main.treeToString(node)});
        if (Main.temporaryDebug) {
            new Error("backtrace at TreeFinder.scan()").printStackTrace();
        }
        if (!this.handled(node)) {
            dbug.debug("TreeFinder.scan(%s) skipping, unhandled: %s%n", node.getClass(), Main.treeToString(node));
            return (Void)super.scan(node, p);
        }
        TreePath path = this.getPath(node);
        assert (path == null || path.getLeaf() == node) : String.format("Mismatch: '%s' '%s' '%s'%n", path, path.getLeaf(), node);
        if (path != null) {
            for (Tree t : path) {
                if (t instanceof ParameterizedTypeTree) break;
                if (t.getKind() != Tree.Kind.ANNOTATION) continue;
                return (Void)super.scan(node, p);
            }
        }
        dbug.debug("Considering %d insertions.%n", p.size());
        Iterator<Insertion> it = p.iterator();
        block5: while (it.hasNext()) {
            Integer pos;
            Insertion i = it.next();
            dbug.debug("Considering insertion at tree:%n", new Object[0]);
            dbug.debug("  Insertion: %s%n", i);
            dbug.debug("  At tree: %s%n", Main.firstLine(node.toString()));
            dbug.debug("  Tree info: %s%n", node.getClass());
            if (i.isInserted()) {
                dbug.debug("  ... insertion already inserted%n", new Object[0]);
                it.remove();
                continue;
            }
            if (!i.getCriteria().isSatisfiedBy(path, node)) {
                dbug.debug("  ... insertion not satisfied%n", new Object[0]);
                continue;
            }
            dbug.debug("  ... insertion satisfied!%n", new Object[0]);
            dbug.debug("    At tree: %s%n", Main.firstLine(node.toString()));
            dbug.debug("    Tree info: %s%n", node.getClass());
            ASTPath astPath = i.getCriteria().getASTPath();
            dbug.debug("    astPath = %s [%s]%n", astPath, astPath == null ? null : astPath.getClass());
            if (i.getKind() == Insertion.Kind.ANNOTATION) {
                AnnotationDef adef = ((AnnotationInsertion)i).getAnnotation().def();
                boolean isTypeAnnotation = adef.isTypeAnnotation();
                switch (node.getKind()) {
                    case NEW_CLASS: {
                        if (isTypeAnnotation) break;
                        continue block5;
                    }
                    case IDENTIFIER: {
                        IdentifierTree id;
                        Tree parent = this.parent(node);
                        Tree.Kind parentKind = parent.getKind();
                        if (parentKind != Tree.Kind.NEW_CLASS && !(id = (IdentifierTree)node).getName().contentEquals("this")) break;
                        continue block5;
                    }
                }
            }
            Integer n = astPath == null ? this.findPosition(path, i) : (pos = Main.convert_jaifs ? null : this.findPositionByASTPath(astPath, path, i));
            if (pos != null) {
                dbug.debug("  ... satisfied! at %d for node of type %s: %s%n", pos, node.getClass(), Main.treeToString(node));
                this.insertions.put(IPair.of(pos, astPath), i);
            }
            it.remove();
        }
        return (Void)super.scan(node, p);
    }

    Integer findPosition(TreePath path, Insertion i) {
        Tree node = path.getLeaf();
        try {
            MethodTree method;
            if (i.getCriteria().isOnReceiver() && path.getParentPath().getParentPath().getLeaf() instanceof NewClassTree) {
                warn.debug("WARNING: Cannot insert a receiver parameter on a method declaration of an anonymous inner class.  This insertion will be skipped.%n    Insertion: %s%n", i);
                return null;
            }
            if (this.alreadyPresent(path, i) && !(i instanceof TypedInsertion)) {
                return null;
            }
            if (i.getKind() == Insertion.Kind.CONSTRUCTOR) {
                ConstructorInsertion cons = (ConstructorInsertion)i;
                if (node instanceof MethodTree) {
                    method = (JCTree.JCMethodDecl)node;
                    if (((JCTree.JCMethodDecl)method).sym.owner.isAnonymous()) {
                        return null;
                    }
                    if ((((JCTree.JCMethodDecl)method).mods.flags & 0x1000000000L) != 0L) {
                        this.addConstructor(path, cons, method);
                    } else {
                        cons.setAnnotationsOnly(true);
                        cons.setInserted(true);
                        i = cons.getReceiverInsertion();
                        if (i == null) {
                            return null;
                        }
                    }
                } else {
                    cons.setAnnotationsOnly(true);
                }
            }
            if (i.getKind() == Insertion.Kind.RECEIVER && node instanceof MethodTree) {
                ReceiverInsertion receiver = (ReceiverInsertion)i;
                method = (MethodTree)node;
                VariableTree rcv = method.getReceiverParameter();
                if (rcv == null) {
                    this.addReceiverType(path, receiver, method);
                }
            }
            if (i.getKind() == Insertion.Kind.NEW && node instanceof NewArrayTree) {
                NewInsertion neu = (NewInsertion)i;
                NewArrayTree newArray = (NewArrayTree)node;
                if (newArray.toString().startsWith("{")) {
                    this.addNewType(neu, newArray);
                }
            }
            Integer pos = -1;
            Map<Tree, ASTRecord> astIndex = ASTIndex.indexOf(this.tree);
            ASTRecord insertRecord = astIndex.get(node);
            dbug.debug("TreeFinder.scan: node=%s%n  critera=%s%n", node, i.getCriteria());
            if (TreePathUtil.hasClassKind(node) && i.getCriteria().isOnTypeDeclarationExtendsClause() && ((ClassTree)node).getExtendsClause() == null) {
                return this.implicitClassBoundPosition((JCTree.JCClassDecl)node, i);
            }
            if (node instanceof MethodTree && i.getCriteria().isOnReturnType()) {
                JCTree.JCMethodDecl jcnode = (JCTree.JCMethodDecl)node;
                JCTree returnType = jcnode.getReturnType();
                insertRecord = insertRecord.extend(Tree.Kind.METHOD, "type");
                if (returnType == null) {
                    pos = this.findMethodName(jcnode);
                    if (pos < 0) {
                        return null;
                    }
                    dbug.debug("pos=%d at constructor name: %s%n", pos, jcnode.sym.toString());
                } else {
                    IPair pair = (IPair)this.tpf.scan(returnType, i);
                    insertRecord = (ASTRecord)pair.first;
                    pos = (Integer)pair.second;
                    assert (this.handled(node));
                    dbug.debug("pos=%d at return type node: %s%n", pos, returnType.getClass());
                }
            } else if (node instanceof TypeParameterTree && i.getCriteria().onBoundZero() && (((TypeParameterTree)node).getBounds().isEmpty() || ((JCTree.JCExpression)((TypeParameterTree)node).getBounds().get((int)0)).type.tsym.isInterface()) || node instanceof WildcardTree && ((WildcardTree)node).getBound() == null && this.wildcardLast(i.getCriteria().getGenericArrayLocation().getLocation())) {
                IPair pair = (IPair)this.tpf.scan(node, i);
                insertRecord = (ASTRecord)pair.first;
                pos = (Integer)pair.second;
                if (i.getKind() == Insertion.Kind.ANNOTATION) {
                    if (node instanceof TypeParameterTree && !((TypeParameterTree)node).getBounds().isEmpty()) {
                        Tree bound = ((TypeParameterTree)node).getBounds().get(0);
                        pos = ((JCTree.JCExpression)bound).getStartPosition();
                        ((AnnotationInsertion)i).setGenerateBound(true);
                    } else {
                        int limit = ((JCTree)this.parent(node)).getEndPosition(this.tree.endPositions);
                        Integer nextpos1 = this.getNthInstanceInRange(',', pos + 1, limit, 1);
                        Integer nextpos2 = this.getNthInstanceInRange('>', pos + 1, limit, 1);
                        pos = nextpos1 != -1 && nextpos1 < nextpos2 ? nextpos1 : nextpos2;
                        ((AnnotationInsertion)i).setGenerateExtends(true);
                    }
                }
            } else if (i.getKind() == Insertion.Kind.CAST) {
                DeclaredType dt;
                Type t = ((CastInsertion)i).getType();
                JCTree jcTree = (JCTree)node;
                pos = jcTree.getStartPosition();
                if (t.getKind() == Type.Kind.DECLARED && (dt = (DeclaredType)t).getName().isEmpty()) {
                    dt.setName(jcTree.type instanceof NullType ? "Object" : jcTree.type.toString());
                }
            } else if (i.getKind() == Insertion.Kind.CLOSE_PARENTHESIS) {
                JCTree jcTree = (JCTree)node;
                pos = jcTree.getEndPosition(this.tree.endPositions);
            } else {
                boolean typeScan = true;
                if (node instanceof MethodTree) {
                    typeScan = i.getCriteria().isOnReceiver();
                } else if (TreePathUtil.hasClassKind(node)) {
                    boolean bl = typeScan = !i.isSeparateLine();
                }
                if (typeScan) {
                    dbug.debug("Calling tpf.scan(%s: %s, %s)%n", node.getClass(), node, i);
                    IPair pair = (IPair)this.tpf.scan(node, i);
                    insertRecord = (ASTRecord)pair.first;
                    pos = (Integer)pair.second;
                    assert (this.handled(node));
                    dbug.debug("pos=%d (insertRecord=%s) at type: %s (%s)%n", pos, insertRecord, node.toString(), node.getClass());
                } else if (node instanceof MethodTree && i.getKind() == Insertion.Kind.CONSTRUCTOR && (((JCTree.JCMethodDecl)node).mods.flags & 0x1000000000L) != 0L) {
                    Tree parent = path.getParentPath().getLeaf();
                    pos = ((JCTree.JCClassDecl)parent).getEndPosition(this.tree.endPositions) - 1;
                    insertRecord = null;
                } else {
                    pos = (Integer)this.dpf.scan(node, null);
                    insertRecord = this.astRecord(node);
                    dbug.debug("pos=%s at declaration: %s%n", pos, node.getClass());
                }
            }
            if (pos != null) {
                assert (pos >= 0) : String.format("pos: %s%nnode: %s%ninsertion: %s%n", pos, node == null ? "null" : String.format("[%s] %s", node.getClass(), node), i);
                this.astInsertions.put(insertRecord, i);
            }
            return pos;
        }
        catch (Throwable e) {
            TreeFinder.reportInsertionError(i, e);
            return null;
        }
    }

    Integer findPositionByASTPath(ASTPath astPath, TreePath path, Insertion i) {
        Tree node = path.getLeaf();
        try {
            MethodTree method;
            ASTPath.ASTEntry entry = astPath.getLast();
            if (entry.getTreeKind() == Tree.Kind.METHOD && entry.childSelectorIs("parameter") && entry.getArgument() == -1 && path.getParentPath().getParentPath().getLeaf() instanceof NewClassTree) {
                warn.debug("WARNING: Cannot insert a receiver parameter on a method declaration of an anonymous inner class.  This insertion will be skipped.%n    Insertion: %s%n", i);
                return null;
            }
            if (this.alreadyPresent(path, i)) {
                return null;
            }
            if (i.getKind() == Insertion.Kind.CONSTRUCTOR) {
                ConstructorInsertion cons = (ConstructorInsertion)i;
                if (node instanceof MethodTree) {
                    method = (JCTree.JCMethodDecl)node;
                    if ((((JCTree.JCMethodDecl)method).mods.flags & 0x1000000000L) != 0L) {
                        this.addConstructor(path, cons, method);
                    } else {
                        cons.setAnnotationsOnly(true);
                        cons.setInserted(true);
                        i = cons.getReceiverInsertion();
                        if (i == null) {
                            return null;
                        }
                    }
                } else {
                    cons.setAnnotationsOnly(true);
                }
            }
            if (i.getKind() == Insertion.Kind.RECEIVER && node instanceof MethodTree) {
                ReceiverInsertion receiver = (ReceiverInsertion)i;
                method = (MethodTree)node;
                if (method.getReceiverParameter() == null) {
                    this.addReceiverType(path, receiver, method);
                }
            }
            if (i.getKind() == Insertion.Kind.NEW && node instanceof NewArrayTree) {
                NewInsertion neu = (NewInsertion)i;
                NewArrayTree newArray = (NewArrayTree)node;
                if (newArray.toString().startsWith("{")) {
                    this.addNewType(neu, newArray);
                }
            }
            Integer pos = -1;
            Map<Tree, ASTRecord> astIndex = ASTIndex.indexOf(this.tree);
            ASTRecord insertRecord = astIndex.get(node);
            dbug.debug("TreeFinder.scan: node=%s%n  criteria=%s%n", node, i.getCriteria());
            if (TreePathUtil.hasClassKind(node) && entry.childSelectorIs("bound") && entry.getArgument() < 0 && ((ClassTree)node).getExtendsClause() == null) {
                return this.implicitClassBoundPosition((JCTree.JCClassDecl)node, i);
            }
            if (node instanceof MethodTree && i.getCriteria().isOnMethod("<init>()V") && entry.childSelectorIs("parameter") && entry.getArgument() < 0) {
                if (i.getKind() != Insertion.Kind.CONSTRUCTOR) {
                    return null;
                }
                Tree parent = path.getParentPath().getLeaf();
                insertRecord = insertRecord.extend(Tree.Kind.METHOD, "parameter", -1);
                pos = ((JCTree)parent).getEndPosition(this.tree.endPositions) - 1;
            } else if (node instanceof MethodTree && entry.childSelectorIs("type")) {
                JCTree.JCMethodDecl jcnode = (JCTree.JCMethodDecl)node;
                JCTree returnType = jcnode.getReturnType();
                insertRecord = insertRecord.extend(Tree.Kind.METHOD, "type");
                if (returnType == null) {
                    pos = this.findMethodName(jcnode);
                    if (pos < 0) {
                        return null;
                    }
                    dbug.debug("pos=%d at constructor name: %s%n", pos, jcnode.sym.toString());
                } else {
                    IPair pair = (IPair)this.tpf.scan(returnType, i);
                    insertRecord = (ASTRecord)pair.first;
                    pos = (Integer)pair.second;
                    assert (this.handled(node));
                    dbug.debug("pos=%d at return type node: %s%n", pos, returnType.getClass());
                }
            } else if (node instanceof TypeParameterTree && entry.getTreeKind() == Tree.Kind.TYPE_PARAMETER && (((TypeParameterTree)node).getBounds().isEmpty() || ((JCTree.JCExpression)((TypeParameterTree)node).getBounds().get((int)0)).type.tsym.isInterface()) || ASTPath.isWildcard(node.getKind()) && (entry.getTreeKind() == Tree.Kind.TYPE_PARAMETER || ASTPath.isWildcard(entry.getTreeKind())) && entry.childSelectorIs("bound") && (!entry.hasArgument() || entry.getArgument() == 0)) {
                IPair pair = (IPair)this.tpf.scan(node, i);
                insertRecord = (ASTRecord)pair.first;
                pos = (Integer)pair.second;
                if (i.getKind() == Insertion.Kind.ANNOTATION) {
                    if (node instanceof TypeParameterTree && !((TypeParameterTree)node).getBounds().isEmpty()) {
                        Tree bound = ((TypeParameterTree)node).getBounds().get(0);
                        pos = ((JCTree.JCExpression)bound).getStartPosition();
                        ((AnnotationInsertion)i).setGenerateBound(true);
                    } else {
                        int limit = ((JCTree)this.parent(node)).getEndPosition(this.tree.endPositions);
                        Integer nextpos1 = this.getNthInstanceInRange(',', pos + 1, limit, 1);
                        Integer nextpos2 = this.getNthInstanceInRange('>', pos + 1, limit, 1);
                        pos = nextpos1 != -1 && nextpos1 < nextpos2 ? nextpos1 : nextpos2;
                        ((AnnotationInsertion)i).setGenerateExtends(true);
                    }
                }
            } else if (i.getKind() == Insertion.Kind.CAST) {
                DeclaredType dt;
                Type t = ((CastInsertion)i).getType();
                JCTree jcTree = (JCTree)node;
                if (jcTree instanceof VariableTree && !astPath.isEmpty() && astPath.getLast().childSelectorIs("initializer")) {
                    if ((node = ((JCTree.JCVariableDecl)node).getInitializer()) == null) {
                        return null;
                    }
                    jcTree = (JCTree)node;
                }
                pos = jcTree.getStartPosition();
                if (t.getKind() == Type.Kind.DECLARED && (dt = (DeclaredType)t).getName().isEmpty()) {
                    if (jcTree.type instanceof NullType) {
                        dt.setName("Object");
                    } else {
                        t = Insertions.TypeTree.javacTypeToType(jcTree.type);
                        t.setAnnotations(dt.getAnnotations());
                        ((CastInsertion)i).setType(t);
                    }
                }
            } else if (i.getKind() == Insertion.Kind.CLOSE_PARENTHESIS) {
                JCTree jcTree = (JCTree)node;
                if (jcTree instanceof VariableTree && !astPath.isEmpty() && astPath.getLast().childSelectorIs("initializer")) {
                    if ((node = ((JCTree.JCVariableDecl)node).getInitializer()) == null) {
                        return null;
                    }
                    jcTree = (JCTree)node;
                }
                pos = jcTree.getEndPosition(this.tree.endPositions);
            } else {
                boolean typeScan = true;
                if (node instanceof MethodTree) {
                    typeScan = IndexFileSpecification.isOnReceiver(i.getCriteria());
                } else if (node.getKind() == Tree.Kind.CLASS) {
                    boolean bl = typeScan = !i.isSeparateLine();
                }
                if (typeScan) {
                    dbug.debug("Calling tpf.scan(%s: %s)%n", node.getClass(), node);
                    IPair pair = (IPair)this.tpf.scan(node, i);
                    insertRecord = (ASTRecord)pair.first;
                    pos = (Integer)pair.second;
                    assert (this.handled(node));
                    dbug.debug("pos=%d at type: %s (%s)%n", pos, node.toString(), node.getClass());
                } else if (node instanceof MethodTree && i.getKind() == Insertion.Kind.CONSTRUCTOR && (((JCTree.JCMethodDecl)node).mods.flags & 0x1000000000L) != 0L) {
                    Tree parent = path.getParentPath().getLeaf();
                    pos = ((JCTree.JCClassDecl)parent).getEndPosition(this.tree.endPositions) - 1;
                    insertRecord = null;
                } else {
                    pos = (Integer)this.dpf.scan(node, null);
                    insertRecord = this.astRecord(node);
                    assert (pos != null);
                    dbug.debug("pos=%d at declaration: %s%n", pos, node.getClass());
                }
            }
            if (pos != null) {
                assert (pos >= 0) : String.format("pos: %s%nnode: %s%ninsertion: %s%n", pos, node, i);
                this.astInsertions.put(insertRecord, i);
            }
            return pos;
        }
        catch (Throwable e) {
            TreeFinder.reportInsertionError(i, e);
            return null;
        }
    }

    private Integer implicitClassBoundPosition(JCTree.JCClassDecl cd, Insertion i) {
        Integer pos;
        if (cd.sym == null || cd.sym.isAnonymous() || i.getKind() != Insertion.Kind.ANNOTATION) {
            return null;
        }
        JCTree.JCModifiers mods = cd.getModifiers();
        String name = cd.getSimpleName().toString();
        if (cd.typarams == null || cd.typarams.isEmpty()) {
            int start = cd.getStartPosition();
            int offset = Math.max(start, mods.getEndPosition(this.tree.endPositions) + 1);
            String s = cd.toString().substring(offset - start);
            Pattern p = Pattern.compile("(?:\\s|//.*$|/\\*[^*]*+\\*++(?:[^*/][^*]*+\\*++)*+/)*+class(?:\\s|//.*$|/\\*[^*]*+\\*++(?:[^*/][^*]*+\\*++)*+/)++" + Pattern.quote(name) + "\\b");
            Matcher m = p.matcher(s);
            if (!m.find() || m.start() != 0) {
                return null;
            }
            pos = offset + m.end() - 1;
        } else {
            JCTree.JCTypeParameter param = cd.typarams.get(cd.typarams.length() - 1);
            int start = param.getEndPosition(this.tree.endPositions);
            pos = this.getFirstInstanceAfter('>', start) + 1;
        }
        ((AnnotationInsertion)i).setGenerateExtends(true);
        return pos;
    }

    private int findMethodName(JCTree.JCMethodDecl node) {
        String sym = node.sym.toString();
        String name = sym.substring(0, sym.indexOf(40));
        JCTree.JCModifiers mods = node.getModifiers();
        JCTree.JCBlock body = node.body;
        if ((mods.flags & 0x1000000000L) != 0L) {
            return -1;
        }
        int nodeStart = node.getStartPosition();
        int nodeEnd = node.getEndPosition(this.tree.endPositions);
        int nodeLength = nodeEnd - nodeStart;
        int modsLength = mods.getEndPosition(this.tree.endPositions) - mods.getStartPosition();
        int bodyLength = body == null ? 1 : body.getEndPosition(this.tree.endPositions) - body.getStartPosition();
        int start = nodeStart + modsLength;
        int end = nodeStart + nodeLength - bodyLength;
        int angle = name.lastIndexOf(62);
        if (angle >= 0) {
            name = name.substring(angle + 1);
        }
        try {
            CharSequence s = this.tree.getSourceFile().getCharContent(true);
            String regex = "\\b" + Pattern.quote(name) + "\\b";
            Pattern pat = Pattern.compile(regex, 8);
            Matcher mat = pat.matcher(s).region(start, end);
            return mat.find() ? mat.start() : -1;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean alreadyPresent(TreePath path, Insertion ins) {
        java.util.List<? extends AnnotationTree> alreadyPresent = null;
        ExpressionTree childExpression = null;
        if (path != null) {
            for (Tree tree : path) {
                Tree type;
                if (tree.getKind() == Tree.Kind.CLASS) {
                    alreadyPresent = ((ClassTree)tree).getModifiers().getAnnotations();
                    break;
                }
                if (tree instanceof MethodTree) {
                    alreadyPresent = ((MethodTree)tree).getModifiers().getAnnotations();
                    break;
                }
                if (tree instanceof VariableTree) {
                    boolean foundChild;
                    VariableTree vt = (VariableTree)tree;
                    boolean bl = foundChild = childExpression != null && vt.getInitializer() == childExpression;
                    if (foundChild) break;
                    alreadyPresent = vt.getModifiers().getAnnotations();
                    break;
                }
                if (tree instanceof TypeCastTree) {
                    type = ((TypeCastTree)tree).getType();
                    if (!(type instanceof AnnotatedTypeTree)) break;
                    alreadyPresent = ((AnnotatedTypeTree)type).getAnnotations();
                    break;
                }
                if (tree instanceof InstanceOfTree) {
                    type = ((InstanceOfTree)tree).getType();
                    if (!(type instanceof AnnotatedTypeTree)) break;
                    alreadyPresent = ((AnnotatedTypeTree)type).getAnnotations();
                    break;
                }
                if (tree instanceof NewClassTree) {
                    JCTree.JCNewClass nc = (JCTree.JCNewClass)tree;
                    if (!(nc.clazz instanceof AnnotatedTypeTree)) break;
                    alreadyPresent = ((AnnotatedTypeTree)((Object)nc.clazz)).getAnnotations();
                    break;
                }
                if (tree instanceof ParameterizedTypeTree) break;
                if (tree instanceof ArrayTypeTree) {
                    type = ((ArrayTypeTree)tree).getType();
                    if (!(type instanceof AnnotatedTypeTree)) break;
                    alreadyPresent = ((AnnotatedTypeTree)type).getAnnotations();
                    break;
                }
                if (tree instanceof AnnotatedTypeTree) {
                    alreadyPresent = ((AnnotatedTypeTree)tree).getAnnotations();
                    break;
                }
                childExpression = tree instanceof ExpressionTree ? (ExpressionTree)tree : null;
            }
        }
        if (Main.temporaryDebug) {
            Tree leaf = path.getLeaf();
            System.out.printf("alreadyPresent(%s, %s)%n  leaf (%s) = %s%n  => %s%n", new Object[]{path, ins, leaf.getKind(), leaf, alreadyPresent});
        }
        if (alreadyPresent != null) {
            for (AnnotationTree annotationTree : alreadyPresent) {
                String ann = annotationTree.getAnnotationType().toString();
                String text = ins.getText();
                String iann = ((String)Main.removeArgs((String)text).first).trim().substring(text.startsWith("@") ? 1 : 0);
                String iannNoPackage = (String)Insertion.removePackage((String)iann).second;
                if (!ann.equals(iann) && !ann.equals(iannNoPackage)) continue;
                dbug.debug("Already present, not reinserting: %s%n", ann);
                return true;
            }
        }
        return false;
    }

    public static void reportInsertionError(Insertion i, Throwable e) {
        System.err.println("Error processing insertion:");
        System.err.println("\t" + i);
        if (e.getMessage() != null) {
            System.err.println("\tError: " + e.getMessage().replace(System.lineSeparator(), System.lineSeparator() + "\t\t"));
        }
        if (dbug.isEnabled() || Main.print_error_stack) {
            e.printStackTrace();
        } else {
            System.err.println("\tRun with --print_error_stack to see the stack trace.");
        }
        System.err.println("\tThis insertion will be skipped.");
    }

    private void addReceiverType(TreePath path, ReceiverInsertion receiver, MethodTree method) {
        boolean isCon;
        TreePath parent = path;
        Tree leaf = parent.getLeaf();
        Tree.Kind kind = leaf.getKind();
        Type outerType = receiver.getType();
        DeclaredType baseType = receiver.getBaseType();
        DeclaredType innerTypes = null;
        DeclaredType staticType = null;
        boolean skip = isCon = ((MethodTree)leaf).getName().contentEquals("<init>");
        while (kind != Tree.Kind.COMPILATION_UNIT && kind != Tree.Kind.NEW_CLASS) {
            if (kind == Tree.Kind.CLASS || kind == Tree.Kind.INTERFACE || kind == Tree.Kind.ENUM || kind == Tree.Kind.ANNOTATION_TYPE) {
                ClassTree clazz = (ClassTree)leaf;
                String className = clazz.getSimpleName().toString();
                boolean isStatic = kind == Tree.Kind.INTERFACE || kind == Tree.Kind.ENUM || clazz.getModifiers().getFlags().contains((Object)Modifier.STATIC);
                if (skip &= !isStatic) {
                    skip = false;
                    receiver.setQualifyType(true);
                } else if (!className.isEmpty()) {
                    DeclaredType inner = new DeclaredType(className);
                    if (staticType == null) {
                        for (TypeParameterTree typeParameterTree : clazz.getTypeParameters()) {
                            inner.addTypeParameter(new DeclaredType(typeParameterTree.getName().toString()));
                        }
                    }
                    if (staticType == null && isStatic) {
                        inner.setAnnotations(outerType.getAnnotations());
                        outerType.clearAnnotations();
                        staticType = inner;
                    }
                    if (innerTypes == null) {
                        innerTypes = inner;
                    } else {
                        inner.setInnerType(innerTypes);
                        innerTypes = inner;
                    }
                }
            }
            parent = parent.getParentPath();
            leaf = parent.getLeaf();
            kind = leaf.getKind();
        }
        if (isCon && innerTypes == null) {
            throw new IllegalArgumentException("can't annotate (non-existent) receiver of non-inner constructor");
        }
        baseType.setName(innerTypes.getName());
        baseType.setTypeParameters(innerTypes.getTypeParameters());
        baseType.setInnerType(innerTypes.getInnerType());
        if (staticType != null && !innerTypes.getAnnotations().isEmpty()) {
            outerType.setAnnotations(innerTypes.getAnnotations());
        }
        DeclaredType type = staticType == null ? baseType : staticType;
        Insertion.decorateType(receiver.getInnerTypeInsertions(), type, receiver.getCriteria().getASTPath());
        receiver.setAddComma(method.getParameters().size() > 0);
    }

    private void addNewType(NewInsertion neu, NewArrayTree newArray) {
        DeclaredType baseType = neu.getBaseType();
        if (baseType.getName().isEmpty()) {
            java.util.List<String> annotations = neu.getType().getAnnotations();
            Type newType = Insertions.TypeTree.javacTypeToType(((JCTree.JCNewArray)newArray).type);
            for (String ann : annotations) {
                newType.addAnnotation(ann);
            }
            neu.setType(newType);
        }
        Insertion.decorateType(neu.getInnerTypeInsertions(), neu.getType(), neu.getCriteria().getASTPath());
    }

    private void addConstructor(TreePath path, ConstructorInsertion cons, MethodTree method) {
        ReceiverInsertion recv = cons.getReceiverInsertion();
        assert (method == (MethodTree)path.getLeaf());
        ClassTree parent = (ClassTree)path.getParentPath().getLeaf();
        DeclaredType baseType = cons.getBaseType();
        if (baseType.getName().isEmpty()) {
            java.util.List<String> annotations = baseType.getAnnotations();
            String className = parent.getSimpleName().toString();
            DeclaredType newType = new DeclaredType(className);
            cons.setType(newType);
            for (String ann : annotations) {
                newType.addAnnotation(ann);
            }
        }
        if (recv != null) {
            Iterator<Insertion> iter = cons.getInnerTypeInsertions().iterator();
            ArrayList<Insertion> recvInner = new ArrayList<Insertion>();
            this.addReceiverType(path, recv, method);
            while (iter.hasNext()) {
                Insertion i = iter.next();
                if (!i.getCriteria().isOnReceiver()) continue;
                recvInner.add(i);
                iter.remove();
            }
            Insertion.decorateType(recvInner, recv.getType(), cons.getCriteria().getASTPath());
        }
        Insertion.decorateType(cons.getInnerTypeInsertions(), cons.getType(), cons.getCriteria().getASTPath());
    }

    public SetMultimap<ASTRecord, Insertion> getPaths() {
        return Multimaps.unmodifiableSetMultimap(this.astInsertions);
    }

    public SetMultimap<IPair<Integer, ASTPath>, Insertion> getInsertionsByPosition(JCTree.JCCompilationUnit node, java.util.List<Insertion> p) {
        ArrayList<Insertion> uninserted = new ArrayList<Insertion>(p);
        this.scan((Tree)node, (java.util.List<Insertion>)uninserted);
        java.util.List typeDecls = node.getTypeDecls();
        for (Insertion i : uninserted) {
            InClassCriterion c = i.getCriteria().getInClass();
            if (c == null) continue;
            for (Tree t : typeDecls) {
                if (!c.isSatisfiedBy(TreePath.getPath(node, t)) || i.getCriteria().isOnMethod("<init>()V") || i.getCriteria().isOnLocalVariable()) continue;
                System.err.printf("Found class %s, but unable to insert %s:%n  %s%n", c.className, i.getText(), i);
            }
        }
        if (dbug.isEnabled()) {
            for (Insertion i : uninserted) {
                System.err.println("Unable to insert: " + i);
            }
        }
        dbug.debug("getPositions => %d positions%n", this.insertions.size());
        return Multimaps.unmodifiableSetMultimap(this.insertions);
    }

    public SetMultimap<IPair<Integer, ASTPath>, Insertion> getPositions(JCTree.JCCompilationUnit node, Insertions insertions) {
        ArrayList<Insertion> list = new ArrayList<Insertion>();
        this.treePathCache.clear();
        if (Main.temporaryDebug) {
            System.out.println("insertions size: " + insertions.size());
            System.out.println("insertions.forOuterClass(\"\") size: " + insertions.forOuterClass(node, "").size());
            System.out.println("list pre-size: " + list.size());
        }
        list.addAll(insertions.forOuterClass(node, ""));
        if (Main.temporaryDebug) {
            System.out.println("list post-size: " + list.size());
        }
        for (JCTree decl : node.getTypeDecls()) {
            if (decl.getTag() != JCTree.Tag.CLASSDEF) continue;
            String name = ((JCTree.JCClassDecl)decl).sym.className();
            Set<Insertion> forClass = insertions.forOuterClass(node, name);
            if (Main.temporaryDebug) {
                System.out.println("insertions size: " + insertions.size());
                System.out.println("insertions.forOuterClass(" + name + ") size: " + forClass.size());
                System.out.println("list pre-size: " + list.size());
            }
            list.addAll(forClass);
            if (!Main.temporaryDebug) continue;
            System.out.println("list post-size: " + list.size());
        }
        return this.getInsertionsByPosition(node, list);
    }

    public static String toString(TreePath path) {
        StringJoiner result = new StringJoiner(System.lineSeparator() + "    ");
        result.add("TreePath:");
        for (Tree t : path) {
            result.add(TreeFinder.toStringTruncated(t, 65) + " " + (Object)((Object)t.getKind()));
        }
        return result.toString();
    }

    public static String leafToStringTruncated(TreePath path, int length) {
        if (path == null) {
            return "null";
        }
        return TreeFinder.toStringTruncated(path.getLeaf(), length);
    }

    public static String toStringOneLine(Tree tree) {
        return tree.toString().trim().replaceAll("\\s+", " ");
    }

    public static String toStringTruncated(Tree tree, int length) {
        if (length < 6) {
            throw new IllegalArgumentException("bad length " + length);
        }
        String result = TreeFinder.toStringOneLine(tree);
        if (result.length() > length) {
            result = "\"" + result.substring(0, length - 5) + "...\"";
        }
        return result;
    }

    private class TypePositionFinder
    extends TreeScanner<IPair<ASTRecord, Integer>, Insertion> {
        private TypePositionFinder() {
        }

        private IPair<ASTRecord, Integer> pathAndPos(JCTree t) {
            return IPair.of(TreeFinder.this.astRecord(t), t.pos);
        }

        private IPair<ASTRecord, Integer> pathAndPos(JCTree t, int i) {
            return IPair.of(TreeFinder.this.astRecord(t), i);
        }

        private IPair<ASTRecord, Integer> getBaseTypePosition(JCTree t) {
            block9: while (true) {
                switch (t.getKind()) {
                    case IDENTIFIER: 
                    case PRIMITIVE_TYPE: {
                        return this.pathAndPos(t);
                    }
                    case MEMBER_SELECT: {
                        JCTree exp = t;
                        do {
                            JCTree.JCFieldAccess jfa = (JCTree.JCFieldAccess)exp;
                            exp = jfa.getExpression();
                            if (!jfa.sym.isStatic()) continue;
                            return this.pathAndPos(exp, TreeFinder.this.getFirstInstanceAfter('.', exp.getEndPosition(((TreeFinder)TreeFinder.this).tree.endPositions)) + 1);
                        } while (exp instanceof JCTree.JCFieldAccess && ((JCTree.JCFieldAccess)exp).sym.getKind() != ElementKind.PACKAGE);
                        if (exp != null) {
                            Symbol sym;
                            if (exp instanceof IdentifierTree && !(sym = ((JCTree.JCIdent)exp).sym).isStatic() && sym.getKind() != ElementKind.PACKAGE) {
                                return this.pathAndPos(t, t.getStartPosition());
                            }
                            t = exp;
                        }
                        return this.pathAndPos(t, TreeFinder.this.getFirstInstanceAfter('.', t.getEndPosition(((TreeFinder)TreeFinder.this).tree.endPositions)) + 1);
                    }
                    case ARRAY_TYPE: {
                        t = ((JCTree.JCArrayTypeTree)t).elemtype;
                        continue block9;
                    }
                    case PARAMETERIZED_TYPE: {
                        return this.pathAndPos(t, t.getStartPosition());
                    }
                    case EXTENDS_WILDCARD: 
                    case SUPER_WILDCARD: {
                        t = ((JCTree.JCWildcard)t).inner;
                        continue block9;
                    }
                    case UNBOUNDED_WILDCARD: {
                        return this.pathAndPos(t);
                    }
                    case ANNOTATED_TYPE: {
                        t = ((JCTree.JCAnnotatedType)t).underlyingType;
                        continue block9;
                    }
                }
                break;
            }
            throw new RuntimeException(String.format("Unrecognized type (kind=%s, class=%s): %s", new Object[]{t.getKind(), t.getClass(), t}));
        }

        @Override
        public IPair<ASTRecord, Integer> visitVariable(VariableTree node, Insertion ins) {
            Name name = node.getName();
            JCTree.JCVariableDecl jn = (JCTree.JCVariableDecl)node;
            JCTree jt = jn.getType();
            Criteria criteria = ins.getCriteria();
            dbug.debug("TypePositionFinder.visitVariable: %s %s%n", jt, jt.getClass());
            if (name != null && criteria.isOnFieldDeclaration()) {
                return IPair.of(TreeFinder.this.astRecord(node), jn.getStartPosition());
            }
            if (jt instanceof JCTree.JCTypeApply) {
                JCTree.JCExpression type = ((JCTree.JCTypeApply)jt).clazz;
                return this.pathAndPos(type);
            }
            return IPair.of(TreeFinder.this.astRecord(node), jn.pos);
        }

        @Override
        public IPair<ASTRecord, Integer> visitMethod(MethodTree node, Insertion ins) {
            dbug.debug("TypePositionFinder.visitMethod%n", new Object[0]);
            super.visitMethod(node, ins);
            JCTree.JCMethodDecl jcnode = (JCTree.JCMethodDecl)node;
            JCTree.JCVariableDecl jcvar = (JCTree.JCVariableDecl)node.getReceiverParameter();
            if (jcvar != null) {
                return this.pathAndPos(jcvar);
            }
            int pos = -1;
            ASTRecord astPath = TreeFinder.this.astRecord(jcnode).extend(Tree.Kind.METHOD, "parameter", -1);
            if (node.getParameters().isEmpty()) {
                pos = TreeFinder.this.findMethodName(jcnode);
                if (pos >= 0) {
                    pos = TreeFinder.this.getFirstInstanceAfter('(', pos);
                }
                if (++pos <= 0) {
                    throw new RuntimeException("Couldn't find param opening paren for: " + jcnode);
                }
            } else {
                pos = ((JCTree)((Object)node.getParameters().get(0))).getStartPosition();
            }
            return IPair.of(astPath, pos);
        }

        @Override
        public IPair<ASTRecord, Integer> visitIdentifier(IdentifierTree node, Insertion ins) {
            dbug.debug("TypePositionFinder.visitIdentifier(%s)%n", node);
            ASTRecord rec = ASTIndex.indexOf(TreeFinder.this.tree).get(node);
            ASTPath astPath = ins.getCriteria().getASTPath();
            Tree parent = TreeFinder.this.parent(node);
            Integer i = null;
            JCTree.JCIdent jcnode = (JCTree.JCIdent)node;
            if (parent instanceof NewArrayTree) {
                ASTPath.ASTEntry entry;
                dbug.debug("TypePositionFinder.visitIdentifier: recognized array%n", new Object[0]);
                if (astPath == null) {
                    entry = new ASTPath.ASTEntry(Tree.Kind.NEW_ARRAY, "type", 0);
                    astPath = ((TreeFinder)TreeFinder.this).astRecord((Tree)parent).extend((ASTPath.ASTEntry)entry).astPath;
                } else {
                    entry = (ASTPath.ASTEntry)astPath.get(astPath.size() - 1);
                }
                if (entry.childSelectorIs("type")) {
                    int n = entry.getArgument();
                    i = jcnode.getStartPosition();
                    if (n < this.getDimsSize((JCTree.JCExpression)parent)) {
                        i = TreeFinder.this.getNthInstanceInRange('[', i, ((JCTree.JCNewArray)parent).getEndPosition(((TreeFinder)TreeFinder.this).tree.endPositions), n + 1);
                    }
                }
                if (i == null) {
                    i = jcnode.getEndPosition(((TreeFinder)TreeFinder.this).tree.endPositions);
                }
            } else if (parent instanceof NewClassTree) {
                dbug.debug("TypePositionFinder.visitIdentifier: recognized class%n", new Object[0]);
                JCTree.JCNewClass nc = (JCTree.JCNewClass)parent;
                dbug.debug("TypePositionFinder.visitIdentifier: clazz %s (%d) constructor %s%n", nc.clazz, nc.clazz.getPreferredPosition(), nc.constructor);
                i = nc.clazz.getPreferredPosition();
                if (astPath == null) {
                    astPath = ((TreeFinder)TreeFinder.this).astRecord((Tree)node).astPath;
                }
            } else {
                ASTRecord astRecord = TreeFinder.this.astRecord(node);
                astPath = astRecord.astPath;
                i = ((JCTree.JCIdent)node).pos;
            }
            dbug.debug("visitIdentifier(%s) => %d where parent (%s) = %s%n", node, i, parent.getClass(), parent);
            return IPair.of(rec.replacePath(astPath), i);
        }

        @Override
        public IPair<ASTRecord, Integer> visitMemberSelect(MemberSelectTree node, Insertion ins) {
            dbug.debug("TypePositionFinder.visitMemberSelect(%s)%n", node);
            JCTree.JCFieldAccess raw = (JCTree.JCFieldAccess)node;
            return IPair.of(TreeFinder.this.astRecord(node), raw.getEndPosition(((TreeFinder)TreeFinder.this).tree.endPositions) - raw.name.length());
        }

        @Override
        public IPair<ASTRecord, Integer> visitTypeParameter(TypeParameterTree node, Insertion ins) {
            JCTree.JCTypeParameter tp = (JCTree.JCTypeParameter)node;
            return IPair.of(TreeFinder.this.astRecord(node), tp.getStartPosition());
        }

        @Override
        public IPair<ASTRecord, Integer> visitWildcard(WildcardTree node, Insertion ins) {
            JCTree.JCWildcard wc = (JCTree.JCWildcard)node;
            return IPair.of(TreeFinder.this.astRecord(node), wc.getStartPosition());
        }

        @Override
        public IPair<ASTRecord, Integer> visitPrimitiveType(PrimitiveTypeTree node, Insertion ins) {
            dbug.debug("TypePositionFinder.visitPrimitiveType(%s)%n", node);
            return this.pathAndPos((JCTree)((Object)node));
        }

        @Override
        public IPair<ASTRecord, Integer> visitParameterizedType(ParameterizedTypeTree node, Insertion ins) {
            Tree parent = TreeFinder.this.parent(node);
            dbug.debug("TypePositionFinder.visitParameterizedType %s parent=%s%n", node, parent);
            Integer pos = (Integer)this.getBaseTypePosition((JCTree)((JCTree.JCTypeApply)node).getType()).second;
            return IPair.of(TreeFinder.this.astRecord(node), pos);
        }

        private int arrayLevels(com.sun.tools.javac.code.Type t) {
            return t.accept(new Types.SimpleVisitor<Integer, Integer>(){

                @Override
                public Integer visitArrayType(Type.ArrayType t, Integer i) {
                    return t.elemtype.accept(this, i + 1);
                }

                @Override
                public Integer visitType(com.sun.tools.javac.code.Type t, Integer i) {
                    return i;
                }
            }, 0);
        }

        private int arrayLevels(Tree node) {
            int result = 0;
            while (node instanceof ArrayTypeTree) {
                ++result;
                node = ((ArrayTypeTree)node).getType();
            }
            return result;
        }

        private JCTree arrayContentType(JCTree.JCArrayTypeTree att) {
            JCTree node = att;
            while ((node = node.getType()) instanceof ArrayTypeTree) {
            }
            return node;
        }

        private ArrayTypeTree largestContainingArray(Tree node) {
            TreePath p = TreeFinder.this.getPath(node);
            Tree result = TreeFinder.largestContainingArray(p).getLeaf();
            assert (result instanceof ArrayTypeTree);
            return (ArrayTypeTree)result;
        }

        @Override
        public IPair<ASTRecord, Integer> visitArrayType(ArrayTypeTree node, Insertion ins) {
            dbug.debug("TypePositionFinder.visitArrayType(%s)%n", node);
            JCTree.JCArrayTypeTree att = (JCTree.JCArrayTypeTree)node;
            dbug.debug("TypePositionFinder.visitArrayType(%s) preferred = %s%n", node, att.getPreferredPosition());
            ArrayTypeTree largest = this.largestContainingArray(node);
            int largestLevels = this.arrayLevels(largest);
            int levels = this.arrayLevels(node);
            int start = this.arrayContentType(att).getPreferredPosition() + 1;
            int end = att.getEndPosition(((TreeFinder)TreeFinder.this).tree.endPositions);
            int pos = this.arrayInsertPos(start, end);
            dbug.debug("  levels=%d largestLevels=%d%n", levels, largestLevels);
            for (int i = levels; i < largestLevels; ++i) {
                pos = TreeFinder.this.getFirstInstanceAfter('[', pos + 1);
                dbug.debug("  pos %d at i=%d%n", pos, i);
            }
            return IPair.of(TreeFinder.this.astRecord(node), pos);
        }

        private int arrayInsertPos(int start, int end) {
            try {
                CharSequence s = TreeFinder.this.tree.getSourceFile().getCharContent(true);
                int pos = TreeFinder.this.getNthInstanceInRange('[', start, end, 1);
                if (pos < 0) {
                    String nonDot = TreeFinder.otherThan('.');
                    String regex = "(?:(?:\\.\\.?)?" + nonDot + ")*(\\.\\.\\.)";
                    Pattern p = Pattern.compile(regex, 8);
                    Matcher m = p.matcher(s).region(start, end);
                    if (m.find()) {
                        pos = m.start(1);
                    }
                    if (pos < 0) {
                        throw new RuntimeException("no \"[\" or \"...\" in array type");
                    }
                }
                return pos;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public IPair<ASTRecord, Integer> visitCompilationUnit(CompilationUnitTree node, Insertion ins) {
            dbug.debug("TypePositionFinder.visitCompilationUnit%n", new Object[0]);
            JCTree.JCCompilationUnit cu = (JCTree.JCCompilationUnit)node;
            return IPair.of(TreeFinder.this.astRecord(node), cu.getStartPosition());
        }

        @Override
        public IPair<ASTRecord, Integer> visitClass(ClassTree node, Insertion ins) {
            dbug.debug("TypePositionFinder.visitClass%n", new Object[0]);
            JCTree.JCClassDecl cd = (JCTree.JCClassDecl)node;
            JCTree t = cd.mods == null ? cd : cd.mods;
            return IPair.of(TreeFinder.this.astRecord(cd), t.getPreferredPosition());
        }

        private int getDimsSize(JCTree.JCExpression tree) {
            if (tree instanceof JCTree.JCNewArray) {
                JCTree.JCNewArray na = (JCTree.JCNewArray)tree;
                if (na.dims.size() != 0) {
                    return this.arrayLevels(na.type);
                }
                if (na.elemtype != null) {
                    return this.getDimsSize(na.elemtype) + 1;
                }
                assert (na.elems != null);
                int maxDimsSize = 0;
                for (JCTree.JCExpression elem : na.elems) {
                    if (elem instanceof JCTree.JCNewArray) {
                        int elemDimsSize = this.getDimsSize((JCTree.JCNewArray)elem);
                        maxDimsSize = Math.max(maxDimsSize, elemDimsSize);
                        continue;
                    }
                    if (!(elem instanceof JCTree.JCArrayTypeTree)) continue;
                    System.out.printf("JCArrayTypeTree: %s%n", elem);
                }
                return maxDimsSize + 1;
            }
            if (tree instanceof JCTree.JCAnnotatedType) {
                return this.getDimsSize(((JCTree.JCAnnotatedType)tree).underlyingType);
            }
            if (tree instanceof JCTree.JCArrayTypeTree) {
                return 1 + this.getDimsSize(((JCTree.JCArrayTypeTree)tree).elemtype);
            }
            return 0;
        }

        @Override
        public IPair<ASTRecord, Integer> visitNewArray(NewArrayTree node, Insertion ins) {
            int dim;
            dbug.debug("TypePositionFinder.visitNewArray%n", new Object[0]);
            JCTree.JCNewArray na = (JCTree.JCNewArray)node;
            GenericArrayLocationCriterion galc = ins.getCriteria().getGenericArrayLocation();
            ASTRecord rec = ASTIndex.indexOf(TreeFinder.this.tree).get(node);
            ASTPath astPath = ins.getCriteria().getASTPath();
            String childSelector = null;
            int dimsSize = this.getDimsSize(na);
            int n = dim = galc == null ? 0 : galc.getLocation().size();
            if (astPath == null) {
                astPath = ((TreeFinder)TreeFinder.this).astRecord((Tree)node).astPath.extendNewArray(dim);
                childSelector = "type";
            } else {
                int n2;
                ASTPath.ASTEntry lastEntry = null;
                int i = n2 = astPath.size();
                while (--i >= 0 && (lastEntry = (ASTPath.ASTEntry)astPath.get(i)).getTreeKind() != Tree.Kind.NEW_ARRAY) {
                }
                assert (i >= 0) : "no matching path entry (kind=NEW_ARRAY)";
                if (n2 > i + 1) {
                    assert (dim + 1 == dimsSize);
                    Tree typeTree = na.elemtype;
                    int j = i + dim + 1;
                    while (--dim >= 0) {
                        typeTree = ((ArrayTypeTree)typeTree).getType();
                    }
                    block8: while (j < n2) {
                        ASTPath.ASTEntry entry = (ASTPath.ASTEntry)astPath.get(j);
                        switch (entry.getTreeKind()) {
                            case ANNOTATED_TYPE: {
                                typeTree = ((AnnotatedTypeTree)typeTree).getUnderlyingType();
                                continue block8;
                            }
                            case ARRAY_TYPE: {
                                typeTree = ((ArrayTypeTree)typeTree).getType();
                                break;
                            }
                            case MEMBER_SELECT: {
                                if (!(typeTree instanceof JCTree.JCFieldAccess)) break block8;
                                JCTree.JCFieldAccess jfa = (JCTree.JCFieldAccess)typeTree;
                                typeTree = jfa.getExpression();
                                if (jfa.sym.getKind() != ElementKind.PACKAGE) break;
                                continue block8;
                            }
                            case PARAMETERIZED_TYPE: {
                                if (entry.childSelectorIs("typeArgument")) {
                                    int arg = entry.getArgument();
                                    java.util.List<? extends Tree> typeArgs = ((ParameterizedTypeTree)typeTree).getTypeArguments();
                                    typeTree = typeArgs.get(arg);
                                    break;
                                }
                                typeTree = ((ParameterizedTypeTree)typeTree).getType();
                                break;
                            }
                            default: {
                                break block8;
                            }
                        }
                        ++j;
                    }
                    if (j < n2) {
                        return this.getBaseTypePosition(na);
                    }
                    return typeTree.accept(this, ins);
                }
                childSelector = lastEntry.getChildSelector();
                if (dim > 0 && "type".equals(childSelector)) {
                    int j;
                    ASTPath newPath = ASTPath.empty();
                    dim += lastEntry.getArgument();
                    for (j = 0; j < i; ++j) {
                        newPath = newPath.extend((ASTPath.ASTEntry)astPath.get(j));
                    }
                    lastEntry = new ASTPath.ASTEntry(Tree.Kind.NEW_ARRAY, "type", dim);
                    newPath = newPath.extend(lastEntry);
                    while (j < n2) {
                        newPath = newPath.extend((ASTPath.ASTEntry)astPath.get(j));
                        ++j;
                    }
                    astPath = newPath;
                } else {
                    dim = lastEntry.getArgument();
                }
            }
            if ("type".equals(childSelector)) {
                if (na.toString().startsWith("{")) {
                    if (ins.getKind() == Insertion.Kind.ANNOTATION) {
                        Tree parent;
                        TreePath parentPath = TreePath.getPath(TreeFinder.this.tree, (Tree)na).getParentPath();
                        if (parentPath != null && (parent = parentPath.getLeaf()) instanceof VariableTree) {
                            AnnotationInsertion ai = (AnnotationInsertion)ins;
                            JCTree typeTree = ((JCTree.JCVariableDecl)parent).getType();
                            ai.setType(typeTree.toString());
                            return IPair.of(rec.replacePath(astPath), na.getStartPosition());
                        }
                        System.err.println("WARNING: array initializer " + node + " has no explicit type; skipping insertion " + ins);
                        return null;
                    }
                    return IPair.of(rec.replacePath(astPath), na.getStartPosition());
                }
                if (dim == dimsSize) {
                    if (na.elemtype == null) {
                        System.err.println("WARNING: array initializer " + node + " has no explicit type; skipping insertion " + ins);
                        return null;
                    }
                    return this.getBaseTypePosition(na.elemtype);
                }
                if (na.dims.size() != 0) {
                    int startPos = na.getStartPosition();
                    int endPos = na.getEndPosition(((TreeFinder)TreeFinder.this).tree.endPositions);
                    int pos = TreeFinder.this.getNthInstanceInRange('[', startPos, endPos, dim + 1);
                    return IPair.of(rec.replacePath(astPath), pos);
                }
                if (dim == 0) {
                    if (na.elemtype == null) {
                        return IPair.of(rec.replacePath(astPath), na.getStartPosition());
                    }
                    int startPos = na.elemtype.getStartPosition();
                    return IPair.of(rec.replacePath(astPath), TreeFinder.this.getFirstInstanceAfter('[', startPos + 1));
                }
                if (dim == dimsSize) {
                    return IPair.of(rec.replacePath(astPath), na.getType().pos().getStartPosition());
                }
                JCTree.JCArrayTypeTree jcatt = (JCTree.JCArrayTypeTree)na.elemtype;
                for (int i = 1; i < dim; ++i) {
                    JCTree.JCExpression elem = jcatt.elemtype;
                    if (elem.hasTag(JCTree.Tag.ANNOTATED_TYPE)) {
                        elem = ((JCTree.JCAnnotatedType)elem).underlyingType;
                    }
                    assert (elem.hasTag(JCTree.Tag.TYPEARRAY));
                    jcatt = (JCTree.JCArrayTypeTree)elem;
                }
                return IPair.of(rec.replacePath(astPath), jcatt.pos().getPreferredPosition());
            }
            if ("dimension".equals(childSelector)) {
                java.util.List inits = na.getInitializers();
                if (dim < inits.size()) {
                    JCTree.JCExpression expr = (JCTree.JCExpression)inits.get(dim);
                    return IPair.of(TreeFinder.this.astRecord(expr), expr.getStartPosition());
                }
                return null;
            }
            if ("initializer".equals(childSelector)) {
                JCTree.JCExpression expr = (JCTree.JCExpression)((List)na.getDimensions()).get(dim);
                return IPair.of(TreeFinder.this.astRecord(expr), expr.getStartPosition());
            }
            assert (false) : "Unexpected child selector in AST path: " + (childSelector == null ? "null" : String.format("[%s] \"%s\"", childSelector.getClass(), childSelector));
            return null;
        }

        @Override
        public IPair<ASTRecord, Integer> visitNewClass(NewClassTree node, Insertion ins) {
            JCTree.JCNewClass na = (JCTree.JCNewClass)node;
            JCTree.JCExpression className = na.clazz;
            while (!(className instanceof IdentifierTree)) {
                if (className instanceof JCTree.JCAnnotatedType) {
                    className = ((JCTree.JCAnnotatedType)className).underlyingType;
                    continue;
                }
                if (className instanceof JCTree.JCTypeApply) {
                    className = ((JCTree.JCTypeApply)className).clazz;
                    continue;
                }
                if (className instanceof JCTree.JCFieldAccess) {
                    className = ((JCTree.JCFieldAccess)className).selected;
                    continue;
                }
                throw new Error(String.format("unrecognized JCNewClass.clazz (%s): %s%n   surrounding new class tree: %s%n", className.getClass(), className, node));
            }
            return this.visitIdentifier((IdentifierTree)((Object)className), ins);
        }
    }

    private static class DeclarationPositionFinder
    extends TreeScanner<Integer, Void> {
        private DeclarationPositionFinder() {
        }

        @Override
        public Integer visitMethod(MethodTree node, Void p) {
            super.visitMethod(node, null);
            ModifiersTree mt = node.getModifiers();
            java.util.List<? extends AnnotationTree> annos = mt.getAnnotations();
            JCTree before = annos.size() > 1 ? (JCTree.JCAnnotation)annos.get(0) : (node.getReturnType() != null ? (JCTree)node.getReturnType() : (JCTree)((Object)node));
            int declPos = before.getStartPosition();
            int modsPos = ((JCTree.JCModifiers)mt).pos().getStartPosition();
            if (modsPos != -1) {
                declPos = Math.min(declPos, modsPos);
            }
            return declPos;
        }

        @Override
        public Integer visitCompilationUnit(CompilationUnitTree node, Void p) {
            JCTree.JCCompilationUnit cu = (JCTree.JCCompilationUnit)node;
            return cu.getStartPosition();
        }

        @Override
        public Integer visitClass(ClassTree node, Void p) {
            JCTree.JCClassDecl cd = (JCTree.JCClassDecl)node;
            int result = -1;
            if (cd.mods != null && (cd.mods.flags != 0L || cd.mods.annotations.size() > 0)) {
                result = cd.mods.getPreferredPosition();
            }
            if (result < 0) {
                result = cd.getPreferredPosition();
            }
            assert (result >= 0 || cd.name.isEmpty()) : String.format("%d %d %d%n", cd.getStartPosition(), cd.getPreferredPosition(), cd.pos);
            return result < 0 ? null : Integer.valueOf(result);
        }
    }
}

