/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.annotator.scanner;

import com.sun.tools.javac.util.Pair;
import org.checkerframework.afu.annotator.scanner.CastScanner;
import org.checkerframework.afu.annotator.scanner.InstanceOfScanner;
import org.checkerframework.afu.annotator.scanner.LambdaScanner;
import org.checkerframework.afu.annotator.scanner.LocalVariableScanner;
import org.checkerframework.afu.annotator.scanner.MethodCallScanner;
import org.checkerframework.afu.annotator.scanner.NewScanner;
import org.checkerframework.afu.scenelib.io.classfile.CodeOffsetAdapter;
import org.checkerframework.org.objectweb.asm.ClassReader;
import org.checkerframework.org.objectweb.asm.ClassVisitor;
import org.checkerframework.org.objectweb.asm.ClassWriter;
import org.checkerframework.org.objectweb.asm.Handle;
import org.checkerframework.org.objectweb.asm.Label;
import org.checkerframework.org.objectweb.asm.MethodVisitor;

public class MethodOffsetClassVisitor
extends ClassVisitor {
    CodeOffsetAdapter codeOffsetAdapter;
    MethodVisitor methodCodeOffsetAdapter;
    private String methodName = "LocalVariableVisitor: DEFAULT_METHOD";

    public MethodOffsetClassVisitor(int api, ClassReader classReader, ClassWriter classWriter) {
        super(api, classWriter);
        this.codeOffsetAdapter = new CodeOffsetAdapter(api, classReader);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        this.methodName = name + descriptor.substring(0, descriptor.indexOf(")") + 1);
        this.methodCodeOffsetAdapter = this.codeOffsetAdapter.visitMethod(access, name, descriptor, signature, exceptions);
        return new MethodOffsetMethodVisitor(this.api, super.visitMethod(access, name, descriptor, signature, exceptions));
    }

    private class MethodOffsetMethodVisitor
    extends MethodVisitor {
        public MethodOffsetMethodVisitor(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public int getOffset() {
            return MethodOffsetClassVisitor.this.codeOffsetAdapter.getMethodCodeOffset();
        }

        @Override
        public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
            super.visitLocalVariable(name, descriptor, signature, start, end, index);
            LocalVariableScanner.addToMethodNameIndexMap(Pair.of(MethodOffsetClassVisitor.this.methodName, Pair.of(index, start.getOffset())), name);
            LocalVariableScanner.addToMethodNameCounter(MethodOffsetClassVisitor.this.methodName, name, start.getOffset());
            MethodOffsetClassVisitor.this.methodCodeOffsetAdapter.visitLocalVariable(name, descriptor, signature, start, end, index);
        }

        @Override
        public void visitLabel(Label label) {
            super.visitLabel(label);
            MethodOffsetClassVisitor.this.methodCodeOffsetAdapter.visitLabel(label);
        }

        @Override
        public void visitTypeInsn(int opcode, String descriptor) {
            super.visitTypeInsn(opcode, descriptor);
            switch (opcode) {
                case 192: {
                    CastScanner.addCastToMethod(MethodOffsetClassVisitor.this.methodName, this.getOffset());
                    break;
                }
                case 187: 
                case 189: {
                    NewScanner.addNewToMethod(MethodOffsetClassVisitor.this.methodName, this.getOffset());
                    break;
                }
                case 193: {
                    InstanceOfScanner.addInstanceOfToMethod(MethodOffsetClassVisitor.this.methodName, this.getOffset());
                }
            }
            MethodOffsetClassVisitor.this.methodCodeOffsetAdapter.visitTypeInsn(opcode, descriptor);
        }

        @Override
        public void visitMultiANewArrayInsn(String descriptor, int dims) {
            super.visitMultiANewArrayInsn(descriptor, dims);
            NewScanner.addNewToMethod(MethodOffsetClassVisitor.this.methodName, this.getOffset());
            MethodOffsetClassVisitor.this.methodCodeOffsetAdapter.visitMultiANewArrayInsn(descriptor, dims);
        }

        @Override
        public void visitIntInsn(int opcode, int operand) {
            super.visitIntInsn(opcode, operand);
            if (opcode == 188) {
                NewScanner.addNewToMethod(MethodOffsetClassVisitor.this.methodName, this.getOffset());
            }
            MethodOffsetClassVisitor.this.methodCodeOffsetAdapter.visitIntInsn(opcode, operand);
        }

        @Override
        @Deprecated
        public void visitMethodInsn(int opcode, String owner, String name, String descriptor) {
            super.visitMethodInsn(opcode, owner, name, descriptor);
            switch (opcode) {
                case 182: 
                case 184: 
                case 185: {
                    MethodCallScanner.addMethodCallToMethod(MethodOffsetClassVisitor.this.methodName, this.getOffset());
                    break;
                }
            }
            MethodOffsetClassVisitor.this.methodCodeOffsetAdapter.visitMethodInsn(opcode, owner, name, descriptor);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
            switch (opcode) {
                case 182: 
                case 184: 
                case 185: {
                    MethodCallScanner.addMethodCallToMethod(MethodOffsetClassVisitor.this.methodName, this.getOffset());
                    break;
                }
            }
            MethodOffsetClassVisitor.this.methodCodeOffsetAdapter.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        }

        @Override
        public void visitInvokeDynamicInsn(String name, String descriptor, Handle bsm, Object ... bsmArgs) {
            super.visitInvokeDynamicInsn(name, descriptor, bsm, bsmArgs);
            LambdaScanner.addLambdaExpressionToMethod(MethodOffsetClassVisitor.this.methodName, this.getOffset());
            MethodOffsetClassVisitor.this.methodCodeOffsetAdapter.visitInvokeDynamicInsn(name, descriptor, bsm, bsmArgs);
        }

        @Override
        public void visitCode() {
            super.visitCode();
            MethodOffsetClassVisitor.this.methodCodeOffsetAdapter.visitCode();
        }

        @Override
        public void visitInsn(int opcode) {
            super.visitInsn(opcode);
            MethodOffsetClassVisitor.this.methodCodeOffsetAdapter.visitInsn(opcode);
        }

        @Override
        public void visitVarInsn(int opcode, int var) {
            super.visitVarInsn(opcode, var);
            MethodOffsetClassVisitor.this.methodCodeOffsetAdapter.visitVarInsn(opcode, var);
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
            super.visitFieldInsn(opcode, owner, name, descriptor);
            MethodOffsetClassVisitor.this.methodCodeOffsetAdapter.visitFieldInsn(opcode, owner, name, descriptor);
        }

        @Override
        public void visitJumpInsn(int opcode, Label label) {
            super.visitJumpInsn(opcode, label);
            MethodOffsetClassVisitor.this.methodCodeOffsetAdapter.visitJumpInsn(opcode, label);
        }

        @Override
        public void visitLdcInsn(Object cst) {
            super.visitLdcInsn(cst);
            MethodOffsetClassVisitor.this.methodCodeOffsetAdapter.visitLdcInsn(cst);
        }

        @Override
        public void visitIincInsn(int var, int increment) {
            super.visitIincInsn(var, increment);
            MethodOffsetClassVisitor.this.methodCodeOffsetAdapter.visitIincInsn(var, increment);
        }

        @Override
        public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
            super.visitTableSwitchInsn(min, max, dflt, labels);
            MethodOffsetClassVisitor.this.methodCodeOffsetAdapter.visitTableSwitchInsn(min, max, dflt, labels);
        }

        @Override
        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
            super.visitLookupSwitchInsn(dflt, keys, labels);
            MethodOffsetClassVisitor.this.methodCodeOffsetAdapter.visitLookupSwitchInsn(dflt, keys, labels);
        }

        @Override
        public void visitEnd() {
            super.visitEnd();
            MethodOffsetClassVisitor.this.methodCodeOffsetAdapter.visitEnd();
        }
    }
}

