/*
 * Copyright (c) 1995, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package sun.net.www.protocol.http;

import org.checkerframework.checker.mustcall.qual.InheritableMustCall;
import org.checkerframework.framework.qual.AnnotatedFor;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.net.URL;
import java.net.URLConnection;
import java.net.ProtocolException;
import java.net.HttpRetryException;
import java.net.PasswordAuthentication;
import java.net.Authenticator;
import java.net.HttpCookie;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.net.SocketTimeoutException;
import java.net.SocketPermission;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.InetSocketAddress;
import java.net.CookieHandler;
import java.net.ResponseCache;
import java.net.CacheResponse;
import java.net.SecureCacheResponse;
import java.net.CacheRequest;
import java.net.URLPermission;
import java.net.Authenticator.RequestorType;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.security.PrivilegedActionException;
import java.io.*;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Iterator;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Set;
import java.util.StringJoiner;
import jdk.internal.access.JavaNetHttpCookieAccess;
import jdk.internal.access.SharedSecrets;
import sun.net.NetProperties;
import sun.net.NetworkClient;
import sun.net.util.IPAddressUtil;
import sun.net.www.*;
import sun.net.www.http.HttpClient;
import sun.net.www.http.PosterOutputStream;
import sun.net.www.http.ChunkedInputStream;
import sun.net.www.http.ChunkedOutputStream;
import sun.util.logging.PlatformLogger;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.net.MalformedURLException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import static sun.net.www.protocol.http.AuthScheme.BASIC;
import static sun.net.www.protocol.http.AuthScheme.DIGEST;
import static sun.net.www.protocol.http.AuthScheme.NTLM;
import static sun.net.www.protocol.http.AuthScheme.NEGOTIATE;
import static sun.net.www.protocol.http.AuthScheme.KERBEROS;
import static sun.net.www.protocol.http.AuthScheme.UNKNOWN;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetPropertyAction;

@AnnotatedFor("mustcall")
@InheritableMustCall("disconnect")
public class HttpURLConnection extends java.net.HttpURLConnection {

    public static final String userAgent;

    protected HttpClient http;

    protected Handler handler;

    protected Proxy instProxy;

    protected volatile Authenticator authenticator;

    protected volatile AuthCacheImpl authCache;

    protected CacheResponse cachedResponse;

    protected PrintStream ps;

    public enum TunnelState {

        NONE, SETUP, TUNNELING
    }

    public final boolean isLockHeldByCurrentThread();

    public static PlatformLogger getHttpLogger();

    public Object authObj();

    public void authObj(Object authObj);

    @Override
    public void setAuthenticator(Authenticator auth);

    public AuthCacheImpl getAuthCache();

    public void setRequestMethod(String method) throws ProtocolException;

    protected void setNewClient(URL url) throws IOException;

    protected void setNewClient(URL url, boolean useCache) throws IOException;

    protected void setProxiedClient(URL url, String proxyHost, int proxyPort) throws IOException;

    protected void setProxiedClient(URL url, String proxyHost, int proxyPort, boolean useCache) throws IOException;

    protected void proxiedConnect(URL url, String proxyHost, int proxyPort, boolean useCache) throws IOException;

    protected HttpURLConnection(URL u, Handler handler) throws IOException {
    }

    public HttpURLConnection(URL u, String host, int port) throws IOException {
    }

    public HttpURLConnection(URL u, Proxy p) throws IOException {
    }

    @SuppressWarnings("removal")
    protected HttpURLConnection(URL u, Proxy p, Handler handler) throws IOException {
    }

    @Deprecated
    public static void setDefaultAuthenticator(HttpAuthenticator a);

    public static InputStream openConnectionCheckRedirects(URLConnection c) throws IOException;

    public void connect() throws IOException;

    @SuppressWarnings("removal")
    protected void plainConnect() throws IOException;

    SocketPermission URLtoSocketPermission(URL url) throws IOException;

    protected void plainConnect0() throws IOException;

    protected HttpClient getNewHttpClient(URL url, Proxy p, int connectTimeout) throws IOException;

    protected HttpClient getNewHttpClient(URL url, Proxy p, int connectTimeout, boolean useCache) throws IOException;

    @SuppressWarnings("removal")
    @Override
    public OutputStream getOutputStream() throws IOException;

    public boolean streaming();

    @SuppressWarnings("removal")
    @Override
    public InputStream getInputStream() throws IOException;

    @Override
    public InputStream getErrorStream();

    TunnelState tunnelState();

    public void setTunnelState(TunnelState tunnelState);

    public void doTunneling() throws IOException;

    protected HttpCallerInfo getHttpCallerInfo(URL url, String proxy, int port, Authenticator authenticator);

    protected HttpCallerInfo getHttpCallerInfo(URL url, Authenticator authenticator);

    static String connectRequestURI(URL url);

    String getRequestURI() throws IOException;

    public void disconnect();

    boolean usingProxyInternal();

    @Override
    public boolean usingProxy();

    @Override
    public String getHeaderField(String name);

    @Override
    public Map<String, List<String>> getHeaderFields();

    @Override
    public String getHeaderField(int n);

    @Override
    public String getHeaderFieldKey(int n);

    @Override
    public void setRequestProperty(String key, String value);

    MessageHeader getUserSetHeaders();

    @Override
    public void addRequestProperty(String key, String value);

    public void setAuthenticationProperty(String key, String value);

    @Override
    public String getRequestProperty(String key);

    @Override
    public Map<String, List<String>> getRequestProperties();

    @Override
    public void setConnectTimeout(int timeout);

    @Override
    public int getConnectTimeout();

    @Override
    public void setReadTimeout(int timeout);

    @Override
    public int getReadTimeout();

    public CookieHandler getCookieHandler();

    String getMethod();

    static String stripIPv6ZoneId(String host);

    class HttpInputStream extends FilterInputStream {

        public HttpInputStream(InputStream is) {
        }

        public HttpInputStream(InputStream is, CacheRequest cacheRequest) {
        }

        @Override
        public synchronized void mark(int readlimit);

        @Override
        public synchronized void reset() throws IOException;

        @Override
        public int read() throws IOException;

        @Override
        public int read(byte[] b) throws IOException;

        @Override
        public int read(byte[] b, int off, int len) throws IOException;

        @Override
        public long skip(long n) throws IOException;

        @Override
        public void close() throws IOException;
    }

    class StreamingOutputStream extends FilterOutputStream {

        @Override
        public void write(int b) throws IOException;

        @Override
        public void write(byte[] b) throws IOException;

        @Override
        public void write(byte[] b, int off, int len) throws IOException;

        void checkError() throws IOException;

        boolean writtenOK();

        @Override
        public void close() throws IOException;
    }

    static class ErrorStream extends InputStream {

        public static InputStream getErrorStream(InputStream is, long cl, HttpClient http);

        @Override
        public int available() throws IOException;

        public int read() throws IOException;

        @Override
        public int read(byte[] b) throws IOException;

        @Override
        public int read(byte[] b, int off, int len) throws IOException;

        @Override
        public void close() throws IOException;
    }
}

class EmptyInputStream extends InputStream {

    @Override
    public int available();

    public int read();
}
