/*
 * Copyright (c) 1996, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package java.net;

import org.checkerframework.checker.mustcall.qual.InheritableMustCall;
import org.checkerframework.framework.qual.AnnotatedFor;
import java.io.InputStream;
import java.io.IOException;
import java.security.Permission;
import java.util.Date;

@AnnotatedFor("mustcall")
@InheritableMustCall("disconnect")
public abstract class HttpURLConnection extends URLConnection {

    protected String method;

    protected int chunkLength;

    protected int fixedContentLength;

    protected long fixedContentLengthLong;

    public void setAuthenticator(Authenticator auth);

    public String getHeaderFieldKey(int n);

    public void setFixedLengthStreamingMode(int contentLength);

    public void setFixedLengthStreamingMode(long contentLength);

    public void setChunkedStreamingMode(int chunklen);

    public String getHeaderField(int n);

    protected int responseCode;

    protected String responseMessage;

    protected boolean instanceFollowRedirects;

    protected HttpURLConnection(URL u) {
    }

    public static void setFollowRedirects(boolean set);

    public static boolean getFollowRedirects();

    public void setInstanceFollowRedirects(boolean followRedirects);

    public boolean getInstanceFollowRedirects();

    public void setRequestMethod(String method) throws ProtocolException;

    public String getRequestMethod();

    public int getResponseCode() throws IOException;

    public String getResponseMessage() throws IOException;

    @SuppressWarnings("deprecation")
    public long getHeaderFieldDate(String name, long defaultValue);

    public abstract void disconnect();

    public abstract boolean usingProxy();

    public Permission getPermission() throws IOException;

    public InputStream getErrorStream();

    public static final int HTTP_OK;

    public static final int HTTP_CREATED;

    public static final int HTTP_ACCEPTED;

    public static final int HTTP_NOT_AUTHORITATIVE;

    public static final int HTTP_NO_CONTENT;

    public static final int HTTP_RESET;

    public static final int HTTP_PARTIAL;

    public static final int HTTP_MULT_CHOICE;

    public static final int HTTP_MOVED_PERM;

    public static final int HTTP_MOVED_TEMP;

    public static final int HTTP_SEE_OTHER;

    public static final int HTTP_NOT_MODIFIED;

    public static final int HTTP_USE_PROXY;

    public static final int HTTP_BAD_REQUEST;

    public static final int HTTP_UNAUTHORIZED;

    public static final int HTTP_PAYMENT_REQUIRED;

    public static final int HTTP_FORBIDDEN;

    public static final int HTTP_NOT_FOUND;

    public static final int HTTP_BAD_METHOD;

    public static final int HTTP_NOT_ACCEPTABLE;

    public static final int HTTP_PROXY_AUTH;

    public static final int HTTP_CLIENT_TIMEOUT;

    public static final int HTTP_CONFLICT;

    public static final int HTTP_GONE;

    public static final int HTTP_LENGTH_REQUIRED;

    public static final int HTTP_PRECON_FAILED;

    public static final int HTTP_ENTITY_TOO_LARGE;

    public static final int HTTP_REQ_TOO_LONG;

    public static final int HTTP_UNSUPPORTED_TYPE;

    @Deprecated
    public static final int HTTP_SERVER_ERROR;

    public static final int HTTP_INTERNAL_ERROR;

    public static final int HTTP_NOT_IMPLEMENTED;

    public static final int HTTP_BAD_GATEWAY;

    public static final int HTTP_UNAVAILABLE;

    public static final int HTTP_GATEWAY_TIMEOUT;

    public static final int HTTP_VERSION;
}
