/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.scenelib.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.checkerframework.afu.scenelib.el.AScene;
import org.checkerframework.afu.scenelib.el.DefException;
import org.checkerframework.afu.scenelib.io.IndexFileParser;
import org.checkerframework.afu.scenelib.io.IndexFileWriter;
import org.checkerframework.afu.scenelib.util.DiffVisitor;

public class SceneOps {
    private SceneOps() {
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 3 || !"diff".equals(args[0])) {
            System.err.println("usage: java annotations.util.SceneOps diff first.jaif second.jaif");
            System.exit(1);
        }
        AScene s1 = new AScene();
        AScene s2 = new AScene();
        try {
            IndexFileParser.parseFile(args[1], s1);
            IndexFileParser.parseFile(args[2], s2);
            AScene diff = SceneOps.diff(s1, s2);
            PrintWriter w = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8)));
            try {
                IndexFileWriter.write(diff, w);
            }
            catch (DefException e) {
                SceneOps.exitWithException(e);
            }
            ((Writer)w).flush();
        }
        catch (IOException e) {
            SceneOps.exitWithException(e);
        }
    }

    public static AScene diff(AScene s1, AScene s2) {
        AScene diff = new AScene();
        new DiffVisitor().visitScene(s1, s2, diff);
        diff.prune();
        return diff;
    }

    private static void exitWithException(Exception e) {
        e.printStackTrace();
        System.exit(1);
    }

    public static void testDiffEmpties() {
        assert (new AScene().equals(SceneOps.diff(new AScene(), new AScene())));
    }

    public static void testDiffSame() throws IOException {
        String dirname = "test/annotations/tests/classfile/cases";
        String[] testcases = new String[]{"ClassEmpty", "ClassNonEmpty", "FieldGeneric", "FieldSimple", "LocalVariableGenericArray", "MethodReceiver", "MethodReturnTypeGenericArray", "ObjectCreationGenericArray", "ObjectCreation", "TypecastGenericArray", "Typecast"};
        AScene emptyScene = new AScene();
        for (String testcase : testcases) {
            AScene scene1 = new AScene();
            AScene scene2 = new AScene();
            String filename = dirname + "/Test" + testcase + ".jaif";
            IndexFileParser.parseFile(filename, scene1);
            IndexFileParser.parseFile(filename, scene2);
            assert (emptyScene.equals(SceneOps.diff(scene1, scene1)));
            assert (emptyScene.equals(SceneOps.diff(scene1, scene2)));
        }
    }
}

