/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.annotator.find;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.afu.annotator.Main;
import org.checkerframework.afu.annotator.find.CaseUtils;
import org.checkerframework.afu.annotator.find.Criterion;
import org.checkerframework.afu.annotator.find.Insertions;
import org.checkerframework.afu.annotator.find.TreeFinder;
import org.checkerframework.afu.scenelib.io.ASTPath;
import org.checkerframework.checker.interning.qual.FindDistinct;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ASTPathCriterion
implements Criterion {
    public static boolean debug = Main.debug;
    ASTPath astPath;

    public ASTPathCriterion(ASTPath astPath) {
        this.astPath = astPath;
    }

    @Override
    public boolean isSatisfiedBy(@Nullable TreePath path, @FindDistinct Tree leaf) {
        if (path == null) {
            return false;
        }
        assert (path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(@Nullable TreePath path) {
        int i;
        Tree next;
        int actualPathLen;
        ArrayList<Tree> actualPath;
        block15: {
            Object entryKind;
            if (path == null) {
                return false;
            }
            actualPath = new ArrayList<Tree>();
            Tree leaf = path.getLeaf();
            Tree.Kind kind = leaf.getKind();
            while (kind != Tree.Kind.METHOD && !ASTPath.isClassEquiv(kind)) {
                actualPath.add(0, leaf);
                path = path.getParentPath();
                if (path == null) break;
                leaf = path.getLeaf();
                kind = leaf.getKind();
            }
            if (path != null && !this.astPath.isEmpty() && ((entryKind = ((ASTPath.ASTEntry)this.astPath.get(0)).getTreeKind()) == Tree.Kind.METHOD && kind == Tree.Kind.METHOD || entryKind == Tree.Kind.CLASS && ASTPath.isClassEquiv(kind))) {
                actualPath.add(0, leaf);
            }
            if (debug) {
                System.out.println("ASTPathCriterion.isSatisfiedBy");
                System.out.println("  path=" + this.astPath);
                System.out.println("  path elements:");
                for (Tree t : actualPath) {
                    System.out.println("  " + (Object)((Object)t.getKind()) + ": " + Main.treeToString(t));
                }
            }
            int astPathLen = this.astPath.size();
            actualPathLen = actualPath.size();
            if (astPathLen == 0 || actualPathLen == 0) {
                return false;
            }
            next = null;
            i = 0;
            do {
                ASTPath.ASTEntry astNode = (ASTPath.ASTEntry)this.astPath.get(i);
                Tree actualNode = (Tree)actualPath.get(i);
                if (!this.kindsMatch(astNode.getTreeKind(), actualNode.getKind())) {
                    return this.isBoundableWildcard(actualPath, i);
                }
                if (debug) {
                    System.out.println("astNode: " + astNode);
                    System.out.println("actualNode: " + (Object)((Object)actualNode.getKind()));
                }
                if ((next = this.getNext(actualNode, this.astPath, i)) == null) {
                    return this.checkNull(actualPath, i);
                }
                if (!(next instanceof JCTree) && actualPathLen == i + 1) {
                    actualPath.add(next);
                    ++actualPathLen;
                }
                if (debug) {
                    System.out.println("next: " + next);
                }
                if (++i >= astPathLen) break block15;
                if (i < actualPathLen) continue;
                return this.checkNull(actualPath, i - 1);
            } while (this.matchNext(next, (Tree)actualPath.get(i)));
            if (debug) {
                System.out.println("no next match");
            }
            return false;
        }
        if (i < actualPathLen && this.matchNext(next, (Tree)actualPath.get(i)) || i <= actualPathLen && next instanceof NewArrayTree) {
            return true;
        }
        if (debug) {
            System.out.println("no next match");
        }
        return false;
    }

    @Override
    public boolean isOnlyTypeAnnotationCriterion() {
        return false;
    }

    private boolean matchNext(Tree next, Tree node) {
        boolean b1 = next instanceof JCTree;
        boolean b2 = node instanceof JCTree;
        if (b1 && !b2) {
            next = Insertions.TypeTree.fromJCTree((JCTree)next);
        } else if (b2 && !b1) {
            node = Insertions.TypeTree.fromJCTree((JCTree)node);
        }
        try {
            return next.accept(new SimpleTreeVisitor<Boolean, Tree>(){

                @Override
                public Boolean defaultAction(Tree t1, Tree t2) {
                    return t1 == t2;
                }

                @Override
                public Boolean visitIdentifier(IdentifierTree v, Tree t) {
                    return v == t;
                }

                @Override
                public Boolean visitAnnotatedType(AnnotatedTypeTree a1, Tree t) {
                    AnnotatedTypeTree a2 = (AnnotatedTypeTree)t;
                    return ASTPathCriterion.this.matchNext(a1.getUnderlyingType(), a2.getUnderlyingType());
                }

                @Override
                public Boolean visitMemberSelect(MemberSelectTree c1, Tree t) {
                    MemberSelectTree c2 = (MemberSelectTree)t;
                    return c1.getIdentifier().toString().equals(c2.getIdentifier().toString()) && ASTPathCriterion.this.matchNext(c1.getExpression(), c2.getExpression());
                }

                @Override
                public Boolean visitWildcard(WildcardTree d1, Tree t) {
                    return d1 == (WildcardTree)t;
                }

                @Override
                public Boolean visitParameterizedType(ParameterizedTypeTree e1, Tree t) {
                    ParameterizedTypeTree e2 = (ParameterizedTypeTree)t;
                    List<? extends Tree> l2 = e2.getTypeArguments();
                    List<? extends Tree> l1 = e1.getTypeArguments();
                    if (l1.size() == l2.size()) {
                        int i = 0;
                        for (Tree tree : l1) {
                            Tree t2;
                            if (ASTPathCriterion.this.matchNext(tree, t2 = l2.get(i++))) continue;
                            return false;
                        }
                        return ASTPathCriterion.this.matchNext(e1.getType(), e2.getType());
                    }
                    return false;
                }
            }, node);
        }
        catch (RuntimeException ex) {
            return false;
        }
    }

    private Tree getNext(Tree actualNode, ASTPath astPath, int ix) {
        try {
            ASTPath.ASTEntry astNode = (ASTPath.ASTEntry)astPath.get(ix);
            switch (actualNode.getKind()) {
                case ANNOTATED_TYPE: {
                    AnnotatedTypeTree annotatedType = (AnnotatedTypeTree)actualNode;
                    if (astNode.childSelectorIs("annotation")) {
                        List<? extends AnnotationTree> annos;
                        int arg = astNode.getArgument();
                        if (arg >= (annos = annotatedType.getAnnotations()).size()) {
                            return null;
                        }
                        return annos.get(arg);
                    }
                    return annotatedType.getUnderlyingType();
                }
                case ARRAY_ACCESS: {
                    ArrayAccessTree arrayAccess = (ArrayAccessTree)actualNode;
                    if (astNode.childSelectorIs("expression")) {
                        return arrayAccess.getExpression();
                    }
                    return arrayAccess.getIndex();
                }
                case ARRAY_TYPE: {
                    ArrayTypeTree arrayType = (ArrayTypeTree)actualNode;
                    return arrayType.getType();
                }
                case ASSERT: {
                    AssertTree azzert = (AssertTree)actualNode;
                    if (astNode.childSelectorIs("condition")) {
                        return azzert.getCondition();
                    }
                    return azzert.getDetail();
                }
                case ASSIGNMENT: {
                    AssignmentTree assignment = (AssignmentTree)actualNode;
                    if (astNode.childSelectorIs("variable")) {
                        return assignment.getVariable();
                    }
                    return assignment.getExpression();
                }
                case BLOCK: {
                    BlockTree block = (BlockTree)actualNode;
                    int arg = astNode.getArgument();
                    List<? extends StatementTree> statements = block.getStatements();
                    if (arg >= block.getStatements().size()) {
                        return null;
                    }
                    return statements.get(arg);
                }
                case CASE: {
                    CaseTree caze = (CaseTree)actualNode;
                    int arg = astNode.getArgument();
                    if (astNode.childSelectorIs("expression")) {
                        List<? extends ExpressionTree> expressions = CaseUtils.caseTreeGetExpressions(caze);
                        if (arg >= expressions.size()) {
                            return null;
                        }
                        return expressions.get(arg);
                    }
                    List<? extends StatementTree> statements = caze.getStatements();
                    if (arg >= statements.size()) {
                        return null;
                    }
                    return statements.get(arg);
                }
                case CATCH: {
                    CatchTree cach = (CatchTree)actualNode;
                    if (astNode.childSelectorIs("parameter")) {
                        return cach.getParameter();
                    }
                    return cach.getBlock();
                }
                case ANNOTATION: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    ClassTree clazz = (ClassTree)actualNode;
                    int arg = astNode.getArgument();
                    if (astNode.childSelectorIs("typeParameter")) {
                        return clazz.getTypeParameters().get(arg);
                    }
                    if (astNode.childSelectorIs("initializer")) {
                        int i = 0;
                        for (Tree tree : clazz.getMembers()) {
                            if (!(tree instanceof BlockTree) || arg != i++) continue;
                            return tree;
                        }
                        return null;
                    }
                    if (astNode.childSelectorIs("bound")) {
                        return arg < 0 ? clazz.getExtendsClause() : clazz.getImplementsClause().get(arg);
                    }
                    return null;
                }
                case CONDITIONAL_EXPRESSION: {
                    ConditionalExpressionTree conditionalExpression = (ConditionalExpressionTree)actualNode;
                    if (astNode.childSelectorIs("condition")) {
                        return conditionalExpression.getCondition();
                    }
                    if (astNode.childSelectorIs("trueExpression")) {
                        return conditionalExpression.getTrueExpression();
                    }
                    return conditionalExpression.getFalseExpression();
                }
                case DO_WHILE_LOOP: {
                    DoWhileLoopTree doWhileLoop = (DoWhileLoopTree)actualNode;
                    if (astNode.childSelectorIs("condition")) {
                        return doWhileLoop.getCondition();
                    }
                    return doWhileLoop.getStatement();
                }
                case ENHANCED_FOR_LOOP: {
                    EnhancedForLoopTree enhancedForLoop = (EnhancedForLoopTree)actualNode;
                    if (astNode.childSelectorIs("variable")) {
                        return enhancedForLoop.getVariable();
                    }
                    if (astNode.childSelectorIs("expression")) {
                        return enhancedForLoop.getExpression();
                    }
                    return enhancedForLoop.getStatement();
                }
                case EXPRESSION_STATEMENT: {
                    ExpressionStatementTree expressionStatement = (ExpressionStatementTree)actualNode;
                    return expressionStatement.getExpression();
                }
                case FOR_LOOP: {
                    ForLoopTree forLoop = (ForLoopTree)actualNode;
                    if (astNode.childSelectorIs("initializer")) {
                        List<? extends StatementTree> inits;
                        int arg = astNode.getArgument();
                        if (arg >= (inits = forLoop.getInitializer()).size()) {
                            return null;
                        }
                        return inits.get(arg);
                    }
                    if (astNode.childSelectorIs("condition")) {
                        return forLoop.getCondition();
                    }
                    if (astNode.childSelectorIs("update")) {
                        List<? extends ExpressionStatementTree> updates;
                        int arg = astNode.getArgument();
                        if (arg >= (updates = forLoop.getUpdate()).size()) {
                            return null;
                        }
                        return updates.get(arg);
                    }
                    return forLoop.getStatement();
                }
                case IF: {
                    IfTree iff = (IfTree)actualNode;
                    if (astNode.childSelectorIs("condition")) {
                        return iff.getCondition();
                    }
                    if (astNode.childSelectorIs("thenStatement")) {
                        return iff.getThenStatement();
                    }
                    return iff.getElseStatement();
                }
                case INSTANCE_OF: {
                    InstanceOfTree instanceOf = (InstanceOfTree)actualNode;
                    if (astNode.childSelectorIs("expression")) {
                        return instanceOf.getExpression();
                    }
                    return instanceOf.getType();
                }
                case LABELED_STATEMENT: {
                    LabeledStatementTree labeledStatement = (LabeledStatementTree)actualNode;
                    return labeledStatement.getStatement();
                }
                case LAMBDA_EXPRESSION: {
                    LambdaExpressionTree lambdaExpression = (LambdaExpressionTree)actualNode;
                    if (astNode.childSelectorIs("parameter")) {
                        List<? extends VariableTree> params;
                        int arg = astNode.getArgument();
                        if (arg >= (params = lambdaExpression.getParameters()).size()) {
                            return null;
                        }
                        return params.get(arg);
                    }
                    return lambdaExpression.getBody();
                }
                case MEMBER_REFERENCE: {
                    List<? extends ExpressionTree> typeArgs;
                    MemberReferenceTree memberReference = (MemberReferenceTree)actualNode;
                    if (astNode.childSelectorIs("qualifierExpression")) {
                        return memberReference.getQualifierExpression();
                    }
                    int arg = astNode.getArgument();
                    if (arg >= (typeArgs = memberReference.getTypeArguments()).size()) {
                        return null;
                    }
                    return typeArgs.get(arg);
                }
                case MEMBER_SELECT: {
                    MemberSelectTree memberSelect = (MemberSelectTree)actualNode;
                    return memberSelect.getExpression();
                }
                case METHOD: {
                    MethodTree method = (MethodTree)actualNode;
                    if (astNode.childSelectorIs("type")) {
                        return method.getReturnType();
                    }
                    if (astNode.childSelectorIs("parameter")) {
                        int arg = astNode.getArgument();
                        List<? extends VariableTree> params = method.getParameters();
                        return arg < 0 ? method.getReceiverParameter() : (arg < params.size() ? (Tree)params.get(arg) : null);
                    }
                    if (astNode.childSelectorIs("typeParameter")) {
                        int arg = astNode.getArgument();
                        return method.getTypeParameters().get(arg);
                    }
                    return method.getBody();
                }
                case METHOD_INVOCATION: {
                    List<? extends ExpressionTree> args;
                    MethodInvocationTree methodInvocation = (MethodInvocationTree)actualNode;
                    if (astNode.childSelectorIs("typeArgument")) {
                        List<? extends Tree> typeArgs;
                        int arg = astNode.getArgument();
                        if (arg >= (typeArgs = methodInvocation.getTypeArguments()).size()) {
                            return null;
                        }
                        return typeArgs.get(arg);
                    }
                    if (astNode.childSelectorIs("methodSelect")) {
                        return methodInvocation.getMethodSelect();
                    }
                    int arg = astNode.getArgument();
                    if (arg >= (args = methodInvocation.getArguments()).size()) {
                        return null;
                    }
                    return args.get(arg);
                }
                case NEW_ARRAY: {
                    List<? extends ExpressionTree> inits;
                    NewArrayTree newArray = (NewArrayTree)actualNode;
                    if (astNode.childSelectorIs("type")) {
                        Type type = ((JCTree.JCNewArray)newArray).type;
                        Tree typeTree = Insertions.TypeTree.fromJavacType(type);
                        int arg = astNode.getArgument();
                        if (arg == 0 && astPath.size() == ix + 1) {
                            return newArray;
                        }
                        typeTree = ((NewArrayTree)typeTree).getType();
                        while (--arg > 0) {
                            if (!(typeTree instanceof ArrayTypeTree)) {
                                return null;
                            }
                            typeTree = ((ArrayTypeTree)typeTree).getType();
                        }
                        return typeTree;
                    }
                    if (astNode.childSelectorIs("dimension")) {
                        List<? extends ExpressionTree> dims;
                        int arg = astNode.getArgument();
                        return arg < (dims = newArray.getDimensions()).size() ? (Tree)dims.get(arg) : null;
                    }
                    int arg = astNode.getArgument();
                    return arg < (inits = newArray.getInitializers()).size() ? (Tree)inits.get(arg) : null;
                }
                case NEW_CLASS: {
                    NewClassTree newClass = (NewClassTree)actualNode;
                    if (astNode.childSelectorIs("enclosingExpression")) {
                        return newClass.getEnclosingExpression();
                    }
                    if (astNode.childSelectorIs("typeArgument")) {
                        List<? extends Tree> typeArgs;
                        int arg = astNode.getArgument();
                        if (arg >= (typeArgs = newClass.getTypeArguments()).size()) {
                            return null;
                        }
                        return typeArgs.get(arg);
                    }
                    if (astNode.childSelectorIs("identifier")) {
                        return newClass.getIdentifier();
                    }
                    if (astNode.childSelectorIs("argument")) {
                        List<? extends ExpressionTree> args;
                        int arg = astNode.getArgument();
                        if (arg >= (args = newClass.getArguments()).size()) {
                            return null;
                        }
                        return args.get(arg);
                    }
                    return newClass.getClassBody();
                }
                case PARAMETERIZED_TYPE: {
                    List<? extends Tree> typeArgs;
                    ParameterizedTypeTree parameterizedType = (ParameterizedTypeTree)actualNode;
                    if (astNode.childSelectorIs("type")) {
                        return parameterizedType.getType();
                    }
                    int arg = astNode.getArgument();
                    if (arg >= (typeArgs = parameterizedType.getTypeArguments()).size()) {
                        return null;
                    }
                    return typeArgs.get(arg);
                }
                case PARENTHESIZED: {
                    ParenthesizedTree parenthesized = (ParenthesizedTree)actualNode;
                    return parenthesized.getExpression();
                }
                case RETURN: {
                    ReturnTree returnn = (ReturnTree)actualNode;
                    return returnn.getExpression();
                }
                case SWITCH: {
                    List<? extends CaseTree> cases;
                    SwitchTree zwitch = (SwitchTree)actualNode;
                    if (astNode.childSelectorIs("expression")) {
                        return zwitch.getExpression();
                    }
                    int arg = astNode.getArgument();
                    if (arg >= (cases = zwitch.getCases()).size()) {
                        return null;
                    }
                    return cases.get(arg);
                }
                case SYNCHRONIZED: {
                    SynchronizedTree synchronizzed = (SynchronizedTree)actualNode;
                    if (astNode.childSelectorIs("expression")) {
                        return synchronizzed.getExpression();
                    }
                    return synchronizzed.getBlock();
                }
                case THROW: {
                    ThrowTree throww = (ThrowTree)actualNode;
                    return throww.getExpression();
                }
                case TRY: {
                    List<? extends Tree> resources;
                    TryTree tryy = (TryTree)actualNode;
                    if (astNode.childSelectorIs("block")) {
                        return tryy.getBlock();
                    }
                    if (astNode.childSelectorIs("catch")) {
                        List<? extends CatchTree> catches;
                        int arg = astNode.getArgument();
                        if (arg >= (catches = tryy.getCatches()).size()) {
                            return null;
                        }
                        return catches.get(arg);
                    }
                    if (astNode.childSelectorIs("finallyBlock")) {
                        return tryy.getFinallyBlock();
                    }
                    int arg = astNode.getArgument();
                    if (arg >= (resources = tryy.getResources()).size()) {
                        return null;
                    }
                    return resources.get(arg);
                }
                case TYPE_CAST: {
                    TypeCastTree typeCast = (TypeCastTree)actualNode;
                    if (astNode.childSelectorIs("type")) {
                        return typeCast.getType();
                    }
                    return typeCast.getExpression();
                }
                case TYPE_PARAMETER: {
                    TypeParameterTree typeParam = (TypeParameterTree)actualNode;
                    List<? extends Tree> bounds = typeParam.getBounds();
                    int arg = astNode.getArgument();
                    return bounds.get(arg);
                }
                case UNION_TYPE: {
                    UnionTypeTree unionType = (UnionTypeTree)actualNode;
                    int arg = astNode.getArgument();
                    List<? extends Tree> typeAlts = unionType.getTypeAlternatives();
                    if (arg >= typeAlts.size()) {
                        return null;
                    }
                    return typeAlts.get(arg);
                }
                case VARIABLE: {
                    VariableTree var = (VariableTree)actualNode;
                    if (astNode.childSelectorIs("initializer")) {
                        return var.getInitializer();
                    }
                    if (astNode.childSelectorIs("type")) {
                        return var.getType();
                    }
                    return null;
                }
                case WHILE_LOOP: {
                    WhileLoopTree whileLoop = (WhileLoopTree)actualNode;
                    if (astNode.childSelectorIs("condition")) {
                        return whileLoop.getCondition();
                    }
                    return whileLoop.getStatement();
                }
            }
            if (ASTPath.isBinaryOperator(actualNode.getKind())) {
                BinaryTree binary = (BinaryTree)actualNode;
                if (astNode.childSelectorIs("leftOperand")) {
                    return binary.getLeftOperand();
                }
                return binary.getRightOperand();
            }
            if (ASTPath.isCompoundAssignment(actualNode.getKind())) {
                CompoundAssignmentTree compoundAssignment = (CompoundAssignmentTree)actualNode;
                if (astNode.childSelectorIs("variable")) {
                    return compoundAssignment.getVariable();
                }
                return compoundAssignment.getExpression();
            }
            if (ASTPath.isUnaryOperator(actualNode.getKind())) {
                UnaryTree unary = (UnaryTree)actualNode;
                return unary.getExpression();
            }
            if (this.isWildcard(actualNode.getKind())) {
                WildcardTree wildcard = (WildcardTree)actualNode;
                return wildcard.getBound();
            }
            throw new IllegalArgumentException("Illegal kind: " + (Object)((Object)actualNode.getKind()));
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    private boolean checkNull(List<Tree> path, int ix) {
        Tree node = path.get(path.size() - 1);
        int last = this.astPath.size() - 1;
        ASTPath.ASTEntry entry = (ASTPath.ASTEntry)this.astPath.get(ix);
        Tree.Kind kind = entry.getTreeKind();
        switch (kind) {
            case CLASS: {
                return ASTPath.isClassEquiv(kind) && ix == last && entry.getArgument() == -1 && entry.childSelectorIs("bound");
            }
            case TYPE_PARAMETER: {
                return node instanceof TypeParameterTree && ix == last && entry.getArgument() == 0 && entry.childSelectorIs("bound");
            }
            case METHOD: {
                if (!(node instanceof MethodTree)) {
                    return false;
                }
                MethodTree method = (MethodTree)node;
                List<? extends VariableTree> params = method.getParameters();
                if ("<init>".equals(method.getName().toString())) {
                    ASTPath.ASTEntry next;
                    String selector;
                    if (ix == last) {
                        return true;
                    }
                    Tree typeTree = "typeParameter".equals(selector = (next = (ASTPath.ASTEntry)this.astPath.get(++ix)).getChildSelector()) ? (Tree)method.getTypeParameters().get(next.getArgument()) : ("parameter".equals(selector) ? params.get(next.getArgument()).getType() : null);
                    return typeTree != null && this.checkTypePath(ix, typeTree);
                }
                if (entry.childSelectorIs("parameter") && entry.getArgument() == -1) {
                    if (ix == last) {
                        return true;
                    }
                    VariableTree rcvrParam = method.getReceiverParameter();
                    if (rcvrParam != null) {
                        return this.checkTypePath(ix + 1, rcvrParam.getType());
                    }
                }
                return false;
            }
            case NEW_ARRAY: {
                if (!(node instanceof NewArrayTree)) {
                    return false;
                }
                NewArrayTree newArray = (NewArrayTree)node;
                int arg = entry.getArgument();
                if (entry.childSelectorIs("type")) {
                    if (ix == last) {
                        return true;
                    }
                    return arg == ASTPathCriterion.arrayDepth(newArray);
                }
                List<? extends ExpressionTree> typeTrees = entry.childSelectorIs("dimension") ? newArray.getDimensions() : (entry.childSelectorIs("initializer") ? newArray.getInitializers() : null);
                return typeTrees != null && arg < typeTrees.size() && this.checkTypePath(ix + 1, typeTrees.get(arg));
            }
            case UNBOUNDED_WILDCARD: {
                return this.isBoundableWildcard(path, path.size() - 1);
            }
        }
        return false;
    }

    private static int arrayDepth(Tree tree) {
        if (tree instanceof NewArrayTree) {
            NewArrayTree newArray = (NewArrayTree)tree;
            Tree type = newArray.getType();
            if (type != null) {
                return type.accept(new SimpleTreeVisitor<Integer, Integer>(){

                    @Override
                    public Integer visitArrayType(ArrayTypeTree t, Integer i) {
                        return t.getType().accept(this, i + 1);
                    }

                    @Override
                    public Integer defaultAction(Tree t, Integer i) {
                        return i;
                    }
                }, 1);
            }
            int depth = newArray.getDimensions().size();
            for (ExpressionTree expressionTree : newArray.getInitializers()) {
                Tree.Kind kind = expressionTree.getKind();
                if (kind != Tree.Kind.NEW_ARRAY && kind != Tree.Kind.ARRAY_TYPE) continue;
                depth = Math.max(depth, ASTPathCriterion.arrayDepth(expressionTree) + 1);
            }
            return depth;
        }
        if (tree instanceof AnnotatedTypeTree) {
            return ASTPathCriterion.arrayDepth(((AnnotatedTypeTree)tree).getUnderlyingType());
        }
        if (tree instanceof ArrayTypeTree) {
            return 1 + ASTPathCriterion.arrayDepth(((ArrayTypeTree)tree).getType());
        }
        return 0;
    }

    private boolean checkTypePath(int i, Tree typeTree) {
        block11: {
            try {
                block8: while (typeTree != null && i < this.astPath.size()) {
                    ASTPath.ASTEntry entry = (ASTPath.ASTEntry)this.astPath.get(i);
                    Tree.Kind kind = entry.getTreeKind();
                    switch (kind) {
                        case ANNOTATED_TYPE: {
                            typeTree = ((AnnotatedTypeTree)typeTree).getUnderlyingType();
                            continue block8;
                        }
                        case ARRAY_TYPE: {
                            typeTree = ((ArrayTypeTree)typeTree).getType();
                            break;
                        }
                        case MEMBER_SELECT: {
                            typeTree = ((MemberSelectTree)typeTree).getExpression();
                            break;
                        }
                        case PARAMETERIZED_TYPE: {
                            if (entry.childSelectorIs("typeArgument")) {
                                int arg = entry.getArgument();
                                typeTree = ((ParameterizedTypeTree)typeTree).getTypeArguments().get(arg);
                                break;
                            }
                            typeTree = ((ParameterizedTypeTree)typeTree).getType();
                            break;
                        }
                        default: {
                            if (this.isWildcard(kind)) {
                                return ++i == this.astPath.size();
                            }
                            break block11;
                        }
                    }
                    ++i;
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean kindsMatch(Tree.Kind kind1, Tree.Kind kind2) {
        return kind1 == kind2 ? true : (ASTPath.isClassEquiv(kind1) ? ASTPath.isClassEquiv(kind2) : (ASTPath.isCompoundAssignment(kind1) ? ASTPath.isCompoundAssignment(kind2) : (ASTPath.isUnaryOperator(kind1) ? ASTPath.isUnaryOperator(kind2) : (ASTPath.isBinaryOperator(kind1) ? ASTPath.isBinaryOperator(kind2) : (ASTPath.isWildcard(kind1) ? ASTPath.isWildcard(kind2) : false)))));
    }

    public boolean isBinaryOperator(Tree.Kind kind) {
        return kind == Tree.Kind.MULTIPLY || kind == Tree.Kind.DIVIDE || kind == Tree.Kind.REMAINDER || kind == Tree.Kind.PLUS || kind == Tree.Kind.MINUS || kind == Tree.Kind.LEFT_SHIFT || kind == Tree.Kind.RIGHT_SHIFT || kind == Tree.Kind.UNSIGNED_RIGHT_SHIFT || kind == Tree.Kind.LESS_THAN || kind == Tree.Kind.GREATER_THAN || kind == Tree.Kind.LESS_THAN_EQUAL || kind == Tree.Kind.GREATER_THAN_EQUAL || kind == Tree.Kind.EQUAL_TO || kind == Tree.Kind.NOT_EQUAL_TO || kind == Tree.Kind.AND || kind == Tree.Kind.XOR || kind == Tree.Kind.OR || kind == Tree.Kind.CONDITIONAL_AND || kind == Tree.Kind.CONDITIONAL_OR;
    }

    public boolean isExpression(Tree.Kind kind) {
        switch (kind) {
            case ARRAY_ACCESS: 
            case ASSIGNMENT: 
            case CONDITIONAL_EXPRESSION: 
            case EXPRESSION_STATEMENT: 
            case INSTANCE_OF: 
            case LAMBDA_EXPRESSION: 
            case MEMBER_REFERENCE: 
            case MEMBER_SELECT: 
            case METHOD_INVOCATION: 
            case NEW_ARRAY: 
            case NEW_CLASS: 
            case PARENTHESIZED: 
            case TYPE_CAST: 
            case IDENTIFIER: 
            case POSTFIX_INCREMENT: 
            case POSTFIX_DECREMENT: 
            case PREFIX_INCREMENT: 
            case PREFIX_DECREMENT: 
            case UNARY_PLUS: 
            case UNARY_MINUS: 
            case BITWISE_COMPLEMENT: 
            case LOGICAL_COMPLEMENT: 
            case MULTIPLY: 
            case DIVIDE: 
            case REMAINDER: 
            case PLUS: 
            case MINUS: 
            case LEFT_SHIFT: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: 
            case LESS_THAN: 
            case GREATER_THAN: 
            case LESS_THAN_EQUAL: 
            case GREATER_THAN_EQUAL: 
            case EQUAL_TO: 
            case NOT_EQUAL_TO: 
            case AND: 
            case XOR: 
            case OR: 
            case CONDITIONAL_AND: 
            case CONDITIONAL_OR: 
            case MULTIPLY_ASSIGNMENT: 
            case DIVIDE_ASSIGNMENT: 
            case REMAINDER_ASSIGNMENT: 
            case PLUS_ASSIGNMENT: 
            case MINUS_ASSIGNMENT: 
            case LEFT_SHIFT_ASSIGNMENT: 
            case RIGHT_SHIFT_ASSIGNMENT: 
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: 
            case AND_ASSIGNMENT: 
            case XOR_ASSIGNMENT: 
            case OR_ASSIGNMENT: 
            case INT_LITERAL: 
            case LONG_LITERAL: 
            case FLOAT_LITERAL: 
            case DOUBLE_LITERAL: 
            case BOOLEAN_LITERAL: 
            case CHAR_LITERAL: 
            case STRING_LITERAL: 
            case NULL_LITERAL: {
                return true;
            }
        }
        return false;
    }

    private boolean isWildcard(Tree.Kind kind) {
        return kind == Tree.Kind.UNBOUNDED_WILDCARD || kind == Tree.Kind.EXTENDS_WILDCARD || kind == Tree.Kind.SUPER_WILDCARD;
    }

    private boolean isBoundableWildcard(List<Tree> actualPath, int i) {
        if (i <= 0) {
            return false;
        }
        Tree actualNode = actualPath.get(i);
        if (actualNode.getKind() == Tree.Kind.UNBOUNDED_WILDCARD) {
            Tree ancestor = actualPath.get(i - 1);
            if (ancestor instanceof InstanceOfTree) {
                TreeFinder.warn.debug("WARNING: wildcard bounds not allowed in 'instanceof' expression; skipping insertion%n", new Object[0]);
                return false;
            }
            if (i > 1 && ancestor instanceof ParameterizedTypeTree && (ancestor = actualPath.get(i - 2)) instanceof ArrayTypeTree) {
                TreeFinder.warn.debug("WARNING: wildcard bounds not allowed in 'instanceof' expression; skipping insertion%n", new Object[0]);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.AST_PATH;
    }

    public String toString() {
        return "ASTPathCriterion: " + this.astPath;
    }
}

