/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.scenelib.field;

import com.google.common.escape.CharEscaperBuilder;
import com.google.common.escape.Escaper;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.afu.scenelib.field.AFTVisitor;
import org.checkerframework.afu.scenelib.field.ScalarAFT;

public final class BasicAFT
extends ScalarAFT {
    static final Escaper charEscaper = new CharEscaperBuilder().addEscape('\b', "\\b").addEscape('\f', "\\f").addEscape('\n', "\\n").addEscape('\r', "\\r").addEscape('\t', "\\t").addEscape('\"', "\\\"").addEscape('\\', "\\\\").addEscape('\'', "\\'").toEscaper();
    public final Class<?> type;
    public static final Map<Class<?>, BasicAFT> bafts;

    private BasicAFT(Class<?> type) {
        this.type = type;
    }

    public static BasicAFT forType(Class<?> type) {
        return bafts.get(type);
    }

    @Override
    public boolean isValidValue(Object o) {
        return this.type == Byte.TYPE && o instanceof Byte || this.type == Short.TYPE && o instanceof Short || this.type == Integer.TYPE && o instanceof Integer || this.type == Long.TYPE && o instanceof Long || this.type == Float.TYPE && o instanceof Float || this.type == Double.TYPE && o instanceof Double || this.type == Character.TYPE && o instanceof Character || this.type == Boolean.TYPE && o instanceof Boolean || this.type == String.class && o instanceof String;
    }

    @Override
    public String toString() {
        if (this.type == String.class) {
            return "String";
        }
        return this.type.getName();
    }

    @Override
    public void format(StringBuilder sb, Object o) {
        if (this.type == String.class) {
            sb.append("\"");
            sb.append(charEscaper.escape((String)o));
            sb.append("\"");
        } else if (this.type == Long.TYPE) {
            sb.append(o.toString());
            sb.append("L");
        } else if (this.type == Double.TYPE && Double.isNaN((Double)o)) {
            sb.append("0.0/0.0");
        } else if (this.type == Float.TYPE && Float.isNaN(((Float)o).floatValue())) {
            sb.append("0.0f/0.0f");
        } else {
            sb.append(o.toString());
        }
    }

    @Override
    public <R, T> R accept(AFTVisitor<R, T> v, T arg) {
        return v.visitBasicAFT(this, arg);
    }

    static {
        HashMap tempBafts = new HashMap(9);
        tempBafts.put(Byte.TYPE, new BasicAFT(Byte.TYPE));
        tempBafts.put(Short.TYPE, new BasicAFT(Short.TYPE));
        tempBafts.put(Integer.TYPE, new BasicAFT(Integer.TYPE));
        tempBafts.put(Long.TYPE, new BasicAFT(Long.TYPE));
        tempBafts.put(Float.TYPE, new BasicAFT(Float.TYPE));
        tempBafts.put(Double.TYPE, new BasicAFT(Double.TYPE));
        tempBafts.put(Character.TYPE, new BasicAFT(Character.TYPE));
        tempBafts.put(Boolean.TYPE, new BasicAFT(Boolean.TYPE));
        tempBafts.put(String.class, new BasicAFT(String.class));
        bafts = tempBafts;
    }
}

