/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.scenelib.field;

import java.util.Collection;
import org.checkerframework.afu.scenelib.field.AFTVisitor;
import org.checkerframework.afu.scenelib.field.AnnotationFieldType;
import org.checkerframework.afu.scenelib.field.ScalarAFT;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ArrayAFT
extends AnnotationFieldType {
    public final @Nullable ScalarAFT elementType;

    public ArrayAFT(@Nullable ScalarAFT elementType) {
        this.elementType = elementType;
    }

    @Override
    public boolean isValidValue(Object o) {
        if (!(o instanceof Collection)) {
            return false;
        }
        Collection asCollection = (Collection)o;
        if (this.elementType == null) {
            return asCollection.isEmpty();
        }
        for (Object elt : asCollection) {
            if (this.elementType.isValidValue(elt)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return (this.elementType == null ? "unknown" : this.elementType.toString()) + "[]";
    }

    @Override
    public void format(StringBuilder sb, Object o) {
        Collection asCollection = (Collection)o;
        int size = asCollection.size();
        if (size == 1) {
            Object elt = asCollection.iterator().next();
            this.elementType.format(sb, elt);
            return;
        }
        sb.append("{");
        boolean notfirst = false;
        for (Object elt : asCollection) {
            if (notfirst) {
                sb.append(", ");
            } else {
                notfirst = true;
            }
            this.elementType.format(sb, elt);
        }
        sb.append("}");
    }

    @Override
    public <R, T> R accept(AFTVisitor<R, T> v, T arg) {
        return v.visitArrayAFT(this, arg);
    }
}

