/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.scenelib.el;

import java.util.ArrayList;
import java.util.List;
import org.checkerframework.afu.scenelib.el.ATypeElement;
import org.checkerframework.afu.scenelib.el.TypePathEntry;

public abstract class TypeASTMapper<N> {
    protected TypeASTMapper() {
    }

    private static ATypeElement getInnerType(ATypeElement te, List<TypePathEntry> ls) {
        if (ls.isEmpty()) {
            return te;
        }
        return te.innerTypes.getVivify(ls);
    }

    public void traverse(N tastRoot, ATypeElement aslRoot) {
        ArrayList<TypePathEntry> ls = new ArrayList<TypePathEntry>();
        this.traverse1(tastRoot, aslRoot, ls);
    }

    private void traverse1(N n, ATypeElement te, List<TypePathEntry> ls) {
        N elType = this.getElementType(n);
        if (elType == null) {
            this.map(n, TypeASTMapper.getInnerType(te, ls));
            int nta = this.numTypeArguments(n);
            for (int tai = 0; tai < nta; ++tai) {
                ls.add(TypePathEntry.create(3, tai));
                this.traverse1(this.getTypeArgument(n, tai), te, new ArrayList<TypePathEntry>(ls));
                ls.remove(ls.size() - 1);
            }
        } else {
            this.map(n, TypeASTMapper.getInnerType(te, ls));
            int layers = 0;
            while ((elType = this.getElementType(n)) != null) {
                ls.add(TypePathEntry.ARRAY_ELEMENT);
                this.map(elType, TypeASTMapper.getInnerType(te, ls));
                n = elType;
                ++layers;
            }
            int nta = this.numTypeArguments(n);
            for (int tai = 0; tai < nta; ++tai) {
                ls.add(TypePathEntry.create(3, tai));
                this.traverse1(this.getTypeArgument(n, tai), te, ls);
                ls.remove(ls.size() - 1);
            }
            for (int i = 0; i < layers; ++i) {
                ls.remove(ls.size() - 1);
            }
        }
    }

    protected abstract N getElementType(N var1);

    protected abstract int numTypeArguments(N var1);

    protected abstract N getTypeArgument(N var1, int var2);

    protected abstract void map(N var1, ATypeElement var2);
}

