/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.annotator.scanner;

import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.afu.annotator.scanner.CommonScanner;
import org.checkerframework.afu.annotator.scanner.TreePathUtil;

public class LocalVariableScanner
extends CommonScanner {
    private int index = -1;
    private boolean done = false;
    private final Tree varTree;
    private final String varName;
    private static Map<Pair<String, Pair<Integer, Integer>>, String> methodNameIndexMap = new HashMap<Pair<String, Pair<Integer, Integer>>, String>();
    private static Map<String, Map<String, List<Integer>>> methodNameCounter = new HashMap<String, Map<String, List<Integer>>>();

    public static int indexOfVarTree(TreePath origpath, Tree varTree, String varName) {
        TreePath path = TreePathUtil.findCountingContext(origpath);
        if (path == null) {
            return -1;
        }
        LocalVariableScanner lvts = new LocalVariableScanner(varTree, varName);
        try {
            lvts.scan(path, null);
        }
        catch (Throwable e) {
            System.out.println("LocalVariableScanner: can't locate: " + varTree);
            return -2;
        }
        return lvts.index;
    }

    private LocalVariableScanner(Tree varTree, String varName) {
        this.varTree = varTree;
        this.varName = varName;
    }

    @Override
    public Void visitVariable(VariableTree node, Void p) {
        if (this.varName.equals(node.getName().toString())) {
            if (!this.done) {
                ++this.index;
            }
            if (this.varTree == node) {
                this.done = true;
            }
        }
        return null;
    }

    public static void addToMethodNameIndexMap(Pair<String, Pair<Integer, Integer>> varInfo, String name) {
        methodNameIndexMap.put(varInfo, name);
    }

    public static String getFromMethodNameIndexMap(Pair<String, Pair<Integer, Integer>> varInfo) {
        return methodNameIndexMap.get(varInfo);
    }

    public static void addToMethodNameCounter(String methodName, String varName, Integer offset) {
        List<Integer> listOfOffsets;
        Map<String, List<Integer>> nameOffsetCounter = methodNameCounter.get(methodName);
        if (nameOffsetCounter == null) {
            nameOffsetCounter = new HashMap<String, List<Integer>>();
            methodNameCounter.put(methodName, nameOffsetCounter);
        }
        if ((listOfOffsets = nameOffsetCounter.get(varName)) == null) {
            listOfOffsets = new ArrayList<Integer>();
            nameOffsetCounter.put(varName, listOfOffsets);
        }
        listOfOffsets.add(offset);
    }

    public static List<Integer> getFromMethodNameCounter(String methodName, String varName) {
        return methodNameCounter.get(methodName).get(varName);
    }
}

