/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.annotator.scanner;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.tree.JCTree;
import java.lang.reflect.Field;
import org.checkerframework.afu.annotator.scanner.TreePathUtil;

public class InitBlockScanner
extends TreePathScanner<Void, Boolean> {
    private int index = -1;
    private boolean done = false;
    private final Tree tree;
    private static final Field BLOCK_END_POS_FIELD = InitBlockScanner.getBlockEndPosField();

    public static int indexOfInitTree(TreePath path, boolean isStatic) {
        Tree tree = TreePathUtil.findEnclosingInitBlock(path, isStatic).getLeaf();
        path = TreePathUtil.findEnclosingClass(path);
        if (tree == null || path == null) {
            return -1;
        }
        InitBlockScanner bts = new InitBlockScanner(tree);
        bts.scan(path, Boolean.valueOf(isStatic));
        return bts.index;
    }

    private InitBlockScanner(Tree tree) {
        this.tree = tree;
    }

    @Override
    public Void visitBlock(BlockTree node, Boolean isStatic) {
        if (!this.done && isStatic.booleanValue() == node.isStatic() && InitBlockScanner.getBlockEndPos((JCTree.JCBlock)node) >= 0) {
            ++this.index;
        }
        if (this.tree == node) {
            this.done = true;
        }
        return (Void)super.visitBlock(node, isStatic);
    }

    private static int getBlockEndPos(JCTree.JCBlock block) {
        try {
            return BLOCK_END_POS_FIELD.getInt(block);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static Field getBlockEndPosField() {
        try {
            return JCTree.JCBlock.class.getDeclaredField("endpos");
        }
        catch (NoSuchFieldException e1) {
            try {
                return JCTree.JCBlock.class.getDeclaredField("bracePos");
            }
            catch (NoSuchFieldException e2) {
                e2.addSuppressed(e1);
                throw new AssertionError((Object)e2);
            }
        }
    }
}

