/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.annotator.find;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.checkerframework.afu.annotator.find.Criteria;
import org.checkerframework.afu.annotator.find.Insertion;
import org.checkerframework.afu.annotator.find.ReceiverInsertion;
import org.checkerframework.afu.annotator.find.TypedInsertion;
import org.checkerframework.afu.scenelib.type.Type;

public class ConstructorInsertion
extends TypedInsertion {
    private ReceiverInsertion receiverInsertion = null;
    private Set<Insertion> declarationInsertions = new LinkedHashSet<Insertion>();

    public ConstructorInsertion(Type type, Criteria criteria, List<Insertion> innerTypeInsertions) {
        super(type, criteria, true, innerTypeInsertions);
    }

    @Override
    protected String getText(boolean abbreviate) {
        StringBuilder b = new StringBuilder();
        if (this.annotationsOnly) {
            return "";
        }
        String typeString = this.typeToString(this.type, true);
        int dollarPos = typeString.lastIndexOf(36);
        if (dollarPos != -1 && (typeString = typeString.substring(dollarPos + 1)).startsWith("1")) {
            typeString = typeString.substring(1);
        }
        for (Insertion i : this.declarationInsertions) {
            b.append(i.getText(abbreviate)).append(System.lineSeparator());
            if (!abbreviate) continue;
            this.packageNames.addAll(i.getPackageNames());
        }
        b.append("public ").append(typeString).append("(");
        if (this.receiverInsertion != null && !this.receiverInsertion.isInserted()) {
            b.append(this.receiverInsertion.getText(abbreviate));
        }
        b.append(") { super(); }");
        return b.toString();
    }

    protected ReceiverInsertion getReceiverInsertion() {
        return this.receiverInsertion;
    }

    public void addReceiverInsertion(ReceiverInsertion recv) {
        if (this.receiverInsertion == null) {
            this.receiverInsertion = recv;
        } else {
            this.receiverInsertion.getInnerTypeInsertions().addAll(recv.getInnerTypeInsertions());
        }
    }

    public void addDeclarationInsertion(Insertion ins) {
        this.declarationInsertions.add(ins);
        ins.setInserted(true);
    }

    @Override
    protected boolean addLeadingSpace(boolean gotSeparateLine, int pos, char precedingChar) {
        return false;
    }

    @Override
    protected boolean addTrailingSpace(boolean gotSeparateLine) {
        return false;
    }

    @Override
    public Insertion.Kind getKind() {
        return Insertion.Kind.CONSTRUCTOR;
    }

    @Override
    public void setInserted(boolean inserted) {
        super.setInserted(false);
        if (this.receiverInsertion != null) {
            this.receiverInsertion.setInserted(false);
        }
        for (Insertion insertion : this.declarationInsertions) {
            insertion.setInserted(false);
        }
    }

    @Override
    public String toString() {
        return "\"" + this.getText().replace(System.lineSeparator(), " ") + "\" " + super.toString();
    }
}

