/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.scenelib.el;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.StringTokenizer;
import org.checkerframework.afu.scenelib.Annotation;
import org.checkerframework.afu.scenelib.Annotations;
import org.checkerframework.afu.scenelib.el.AElement;
import org.checkerframework.afu.scenelib.field.AnnotationFieldType;
import org.checkerframework.afu.scenelib.util.MethodRecorder;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.signature.qual.BinaryName;
import org.objectweb.asm.ClassReader;

public final class AnnotationDef
extends AElement {
    public final @BinaryName String name;
    public Map<String, AnnotationFieldType> fieldTypes;
    public String source;

    public AnnotationDef(@BinaryName String name, String source) {
        super("annotation: " + name);
        assert (name != null);
        assert (source != null);
        this.name = name;
        this.source = source;
    }

    public static List<String> getDeclaredMethods(String name) {
        List<String> methods;
        try {
            ClassReader classReader = new ClassReader(name);
            MethodRecorder methodRecorder = new MethodRecorder(524288);
            classReader.accept(methodRecorder, 0);
            methods = methodRecorder.getMethods();
        }
        catch (IOException e) {
            methods = null;
            e.printStackTrace();
        }
        return methods;
    }

    public static AnnotationDef fromClass(Class<? extends java.lang.annotation.Annotation> annoType, Map<String, AnnotationDef> adefs) {
        java.lang.annotation.Annotation[] jannos;
        @BinaryName String name = annoType.getName();
        assert (name != null);
        if (adefs.containsKey(name)) {
            return adefs.get(name);
        }
        LinkedHashMap<String, AnnotationFieldType> fieldTypes = new LinkedHashMap<String, AnnotationFieldType>();
        AnnotationDef.getDeclaredMethods(name).forEach(m -> fieldTypes.put((String)m, (AnnotationFieldType)null));
        for (Method m2 : annoType.getDeclaredMethods()) {
            AnnotationFieldType aft = AnnotationFieldType.fromClass(m2.getReturnType(), adefs);
            fieldTypes.put(m2.getName(), aft);
        }
        AnnotationDef result = new AnnotationDef(name, Annotations.noAnnotations, fieldTypes, "class " + annoType);
        adefs.put(name, result);
        try {
            jannos = annoType.getDeclaredAnnotations();
        }
        catch (Exception e) {
            AnnotationDef.printClasspath();
            throw new Error("Exception in anno.getDeclaredAnnotations() for anno = " + annoType, e);
        }
        for (java.lang.annotation.Annotation ja : jannos) {
            result.tlAnnotationsHere.add(new Annotation(ja, adefs));
        }
        return result;
    }

    public AnnotationDef(@BinaryName String name, Set<Annotation> tlAnnotationsHere, String source) {
        super("annotation: " + name);
        assert (name != null);
        assert (source != null);
        this.name = name;
        this.source = source;
        if (tlAnnotationsHere != null) {
            this.tlAnnotationsHere.addAll(tlAnnotationsHere);
        }
    }

    public AnnotationDef(@BinaryName String name, Set<Annotation> tlAnnotationsHere, Map<String, ? extends AnnotationFieldType> fieldTypes, String source) {
        this(name, tlAnnotationsHere, source);
        this.setFieldTypes(fieldTypes);
    }

    @Override
    public AnnotationDef clone() {
        throw new UnsupportedOperationException("Can't duplicate an AnnotationDef");
    }

    public void setFieldTypes(Map<String, ? extends AnnotationFieldType> fieldTypes) {
        this.fieldTypes = Collections.unmodifiableMap(new LinkedHashMap<String, AnnotationFieldType>(fieldTypes));
    }

    public @Nullable RetentionPolicy retention() {
        if (this.tlAnnotationsHere.contains(Annotations.aRetentionClass)) {
            return RetentionPolicy.CLASS;
        }
        if (this.tlAnnotationsHere.contains(Annotations.aRetentionRuntime)) {
            return RetentionPolicy.RUNTIME;
        }
        if (this.tlAnnotationsHere.contains(Annotations.aRetentionSource)) {
            return RetentionPolicy.SOURCE;
        }
        return null;
    }

    public List<String> targets() {
        Annotation target = this.target();
        if (target == null) {
            return null;
        }
        List fieldValue = (List)target.getFieldValue("value");
        return fieldValue;
    }

    public Annotation target() {
        for (Annotation anno : this.tlAnnotationsHere) {
            if (!anno.def().equals(Annotations.adTarget)) continue;
            return anno;
        }
        return null;
    }

    public boolean isTypeAnnotation() {
        List<String> targets = this.targets();
        return targets != null && targets.contains("TYPE_USE");
    }

    public boolean isOnlyTypeAnnotation() {
        boolean result = Annotations.onlyTypeAnnotationTargets.contains(this.target());
        return result;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof AnnotationDef && ((AnnotationDef)o).equals(this);
    }

    public boolean equals(AnnotationDef o) {
        boolean sameName = this.name.equals(o.name);
        boolean sameMetaAnnotations = this.equalsElement(o);
        boolean sameFieldTypes = this.fieldTypes.equals(o.fieldTypes);
        return sameName && sameMetaAnnotations && sameFieldTypes;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode() + this.fieldTypes.hashCode();
    }

    public static AnnotationDef unify(AnnotationDef def1, AnnotationDef def2) {
        if (def1.equals(def2)) {
            return def1;
        }
        if (def1.name.equals(def2.name) && def1.equalsElement(def2)) {
            Set<String> ks1 = def1.fieldTypes.keySet();
            Set<String> ks2 = def2.fieldTypes.keySet();
            if (ks1.isEmpty() || ks2.isEmpty() || ks1.equals(ks2)) {
                LinkedHashMap<String, AnnotationFieldType> newFieldTypes = new LinkedHashMap<String, AnnotationFieldType>();
                for (String fieldName : def1.fieldTypes.keySet()) {
                    AnnotationFieldType uaft;
                    AnnotationFieldType aft1 = def1.fieldTypes.get(fieldName);
                    AnnotationFieldType aft2 = def2.fieldTypes.get(fieldName);
                    AnnotationFieldType annotationFieldType = aft1 == null ? aft2 : (uaft = aft2 == null ? aft1 : AnnotationFieldType.unify(aft1, aft2));
                    if (uaft == null) {
                        return null;
                    }
                    newFieldTypes.put(fieldName, uaft);
                }
                return new AnnotationDef(def1.name, def1.tlAnnotationsHere, newFieldTypes, String.format("unify(%s, %s)", def1.source, def2.source));
            }
        }
        return null;
    }

    @Override
    public String toString() {
        String metaAnnos;
        if (this.tlAnnotationsHere.isEmpty()) {
            metaAnnos = "";
        } else {
            StringJoiner metaAnnosJoiner = new StringJoiner(" ", "[", "]");
            for (Annotation annotation : this.tlAnnotationsHere) {
                metaAnnosJoiner.add(annotation.toString());
            }
            metaAnnos = metaAnnosJoiner.toString() + " ";
        }
        StringJoiner args = new StringJoiner(",", "(", ")");
        for (Map.Entry entry : this.fieldTypes.entrySet()) {
            args.add(((AnnotationFieldType)entry.getValue()).toString() + " " + (String)entry.getKey());
        }
        return metaAnnos.toString() + "@" + this.name + args.toString();
    }

    public String toStringDebug() {
        return this.toString() + String.format("; source=%s, tlAnnotationsHere=%s", this.source, this.tlAnnotationsHere);
    }

    public static void printClasspath() {
        System.out.println("Classpath:");
        StringTokenizer tokenizer = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String cpelt = tokenizer.nextToken();
            boolean exists = new File(cpelt).exists();
            if (!exists) {
                System.out.print(" non-existent:");
            }
            System.out.println("  " + cpelt);
        }
    }
}

