/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.scenelib.io.classfile;

import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.checkerframework.afu.scenelib.Annotation;
import org.checkerframework.afu.scenelib.el.AClass;
import org.checkerframework.afu.scenelib.el.AElement;
import org.checkerframework.afu.scenelib.el.AField;
import org.checkerframework.afu.scenelib.el.AMethod;
import org.checkerframework.afu.scenelib.el.AScene;
import org.checkerframework.afu.scenelib.el.ATypeElement;
import org.checkerframework.afu.scenelib.el.BoundLocation;
import org.checkerframework.afu.scenelib.el.LocalLocation;
import org.checkerframework.afu.scenelib.el.RelativeLocation;
import org.checkerframework.afu.scenelib.el.TypeIndexLocation;
import org.checkerframework.afu.scenelib.el.TypePathEntry;
import org.checkerframework.afu.scenelib.field.AnnotationFieldType;
import org.checkerframework.afu.scenelib.field.ArrayAFT;
import org.checkerframework.afu.scenelib.field.ClassTokenAFT;
import org.checkerframework.afu.scenelib.field.EnumAFT;
import org.checkerframework.afu.scenelib.io.classfile.CodeOffsetAdapter;
import org.checkerframework.afu.scenelib.io.classfile.MethodCodeOffsetAdapter;
import org.checkerframework.checker.signature.qual.ClassGetName;
import org.checkerframework.org.objectweb.asm.AnnotationVisitor;
import org.checkerframework.org.objectweb.asm.Attribute;
import org.checkerframework.org.objectweb.asm.ClassReader;
import org.checkerframework.org.objectweb.asm.ClassVisitor;
import org.checkerframework.org.objectweb.asm.ClassWriter;
import org.checkerframework.org.objectweb.asm.FieldVisitor;
import org.checkerframework.org.objectweb.asm.Handle;
import org.checkerframework.org.objectweb.asm.Label;
import org.checkerframework.org.objectweb.asm.MethodVisitor;
import org.checkerframework.org.objectweb.asm.Type;
import org.checkerframework.org.objectweb.asm.TypePath;
import org.checkerframework.org.objectweb.asm.TypeReference;

public class ClassAnnotationSceneWriter
extends CodeOffsetAdapter {
    private static final boolean strict = false;
    private final AScene scene;
    private AClass aClass;
    private final List<String> existingClassAnnotations;
    private boolean hasVisitedClassAnnotationsInScene;
    private final boolean overwrite;
    private final Map<String, Set<Integer>> dynamicConstructors;
    private final Map<String, Set<Integer>> lambdaExpressions;
    private ClassReader classReader;

    public ClassAnnotationSceneWriter(int api, ClassReader classReader, AScene scene, boolean overwrite) {
        super(api, classReader);
        this.scene = scene;
        this.hasVisitedClassAnnotationsInScene = false;
        this.aClass = null;
        this.existingClassAnnotations = new ArrayList<String>();
        this.overwrite = overwrite;
        this.dynamicConstructors = new HashMap<String, Set<Integer>>();
        this.lambdaExpressions = new HashMap<String, Set<Integer>>();
        this.classReader = classReader;
    }

    public byte[] toByteArray() {
        return ((ClassWriter)this.cv).toByteArray();
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.classReader.accept(new MethodCodeIndexer(this.api), 0);
        super.visit(version, access, name, signature, superName, interfaces);
        name = name.replace('/', '.');
        this.aClass = this.scene.classes.getVivify(name);
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.ensureVisitSceneClassAnnotations();
        super.visitInnerClass(name, outerName, innerName, access);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        this.ensureVisitSceneClassAnnotations();
        return new FieldAnnotationSceneWriter(this.api, name, super.visitField(access, name, descriptor, signature, value));
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        this.ensureVisitSceneClassAnnotations();
        return new MethodAnnotationSceneWriter(this.api, name, descriptor, super.visitMethod(access, name, descriptor, signature, exceptions));
    }

    @Override
    public void visitEnd() {
        this.ensureVisitSceneClassAnnotations();
        super.visitEnd();
    }

    @Override
    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        this.existingClassAnnotations.add(descriptor);
        if (this.aClass.lookup(ClassAnnotationSceneWriter.classDescToName(descriptor)) != null && this.overwrite) {
            return null;
        }
        return super.visitAnnotation(descriptor, visible);
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        this.existingClassAnnotations.add(descriptor);
        if (this.aClass.lookup(ClassAnnotationSceneWriter.classDescToName(descriptor)) != null && this.overwrite) {
            return null;
        }
        return super.visitTypeAnnotation(typeRef, typePath, descriptor, visible);
    }

    private void ensureVisitSceneClassAnnotations() {
        if (!this.hasVisitedClassAnnotationsInScene) {
            this.hasVisitedClassAnnotationsInScene = true;
            for (Annotation annotation : this.aClass.tlAnnotationsHere) {
                if (!this.overwrite && this.existingClassAnnotations.contains(ClassAnnotationSceneWriter.name(annotation))) continue;
                AnnotationVisitor av = this.visitAnnotation(annotation);
                this.visitFields(av, annotation);
                av.visitEnd();
            }
            for (Map.Entry entry : this.aClass.bounds.entrySet()) {
                BoundLocation bloc = (BoundLocation)entry.getKey();
                ATypeElement bound = (ATypeElement)entry.getValue();
                TypeReference typeReference = bloc.boundIndex == -1 ? TypeReference.newTypeParameterReference(0, bloc.paramIndex) : TypeReference.newTypeParameterBoundReference(17, bloc.paramIndex, bloc.boundIndex);
                for (Annotation annotation : bound.tlAnnotationsHere) {
                    AnnotationVisitor xav = this.visitTypeAnnotation(annotation, typeReference, null);
                    this.visitFields(xav, annotation);
                    xav.visitEnd();
                }
                typeReference = TypeReference.newTypeParameterBoundReference(17, bloc.paramIndex, bloc.boundIndex);
                for (Map.Entry entry2 : bound.innerTypes.entrySet()) {
                    TypePath typePath = TypePathEntry.listToTypePath((List)entry2.getKey());
                    ATypeElement innerType = (ATypeElement)entry2.getValue();
                    for (Annotation tla : innerType.tlAnnotationsHere) {
                        AnnotationVisitor xav = this.visitTypeAnnotation(tla, typeReference, typePath);
                        this.visitFields(xav, tla);
                        xav.visitEnd();
                    }
                }
            }
            for (Map.Entry entry : this.aClass.extendsImplements.entrySet()) {
                TypeIndexLocation idx = (TypeIndexLocation)entry.getKey();
                ATypeElement aTypeElement = (ATypeElement)entry.getValue();
            }
        }
    }

    private static boolean isRuntimeRetention(Annotation tla) {
        if (tla.def.retention() == null) {
            return false;
        }
        return tla.def.retention() == RetentionPolicy.RUNTIME;
    }

    private static String name(Annotation tla) {
        return tla.def().name;
    }

    private static String classNameToDesc(String name) {
        return "L" + name.replace('.', '/') + ";";
    }

    private static @ClassGetName String classDescToName(String descriptor) {
        assert (descriptor.startsWith("L"));
        assert (descriptor.endsWith(";"));
        return descriptor.substring(1, descriptor.length() - 1).replace('/', '.');
    }

    private AnnotationVisitor visitAnnotation(Annotation tla) {
        return super.visitAnnotation(ClassAnnotationSceneWriter.classNameToDesc(ClassAnnotationSceneWriter.name(tla)), ClassAnnotationSceneWriter.isRuntimeRetention(tla));
    }

    private AnnotationVisitor visitTypeAnnotation(Annotation tla, TypeReference typeReference, TypePath typePath) {
        return super.visitTypeAnnotation(typeReference.getValue(), typePath, ClassAnnotationSceneWriter.classNameToDesc(ClassAnnotationSceneWriter.name(tla)), ClassAnnotationSceneWriter.isRuntimeRetention(tla));
    }

    private void visitFields(AnnotationVisitor av, Annotation a) {
        for (String fieldName : a.def().fieldTypes.keySet()) {
            Object value = a.getFieldValue(fieldName);
            if (value == null) continue;
            AnnotationFieldType aft = a.def().fieldTypes.get(fieldName);
            if (value instanceof Annotation) {
                AnnotationVisitor nav = av.visitAnnotation(fieldName, ClassAnnotationSceneWriter.classDescToName(a.def().name));
                this.visitFields(nav, a);
                nav.visitEnd();
                continue;
            }
            if (value instanceof List) {
                AnnotationVisitor aav = av.visitArray(fieldName);
                aft = ((ArrayAFT)aft).elementType;
                for (Object o : (List)value) {
                    if (aft instanceof EnumAFT) {
                        aav.visitEnum(null, ((EnumAFT)aft).typeName, o.toString());
                        continue;
                    }
                    if (o instanceof Class) {
                        aav.visit(null, Type.getType((Class)o));
                        continue;
                    }
                    aav.visit(null, o);
                }
                aav.visitEnd();
                continue;
            }
            if (aft instanceof EnumAFT) {
                av.visitEnum(fieldName, ((EnumAFT)aft).typeName, value.toString());
                continue;
            }
            if (aft instanceof ClassTokenAFT) {
                av.visit(fieldName, Type.getType((Class)value));
                continue;
            }
            av.visit(fieldName, value);
        }
    }

    class MethodCodeIndexer
    extends ClassVisitor {
        private int codeStart;
        Set<Integer> constrs;
        Set<Integer> lambdas;

        MethodCodeIndexer(int api) {
            super(api);
            this.codeStart = ((ClassAnnotationSceneWriter)ClassAnnotationSceneWriter.this).classReader.header + 6;
            this.codeStart += 2 + 2 * ClassAnnotationSceneWriter.this.classReader.readUnsignedShort(this.codeStart);
            int fieldCount = ClassAnnotationSceneWriter.this.classReader.readUnsignedShort(this.codeStart);
            this.codeStart += 2;
            while (--fieldCount >= 0) {
                int attrCount = ClassAnnotationSceneWriter.this.classReader.readUnsignedShort(this.codeStart + 6);
                this.codeStart += 8;
                while (--attrCount >= 0) {
                    this.codeStart += 6 + ClassAnnotationSceneWriter.this.classReader.readInt(this.codeStart + 2);
                }
            }
            this.codeStart += 2;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        }

        @Override
        public void visitSource(String source, String debug) {
        }

        @Override
        public void visitOuterClass(String owner, String name, String descriptor) {
        }

        @Override
        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        @Override
        public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
            return null;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            String methodDescription = name + descriptor;
            this.constrs = (Set)ClassAnnotationSceneWriter.this.dynamicConstructors.get(methodDescription);
            if (this.constrs == null) {
                this.constrs = new TreeSet<Integer>();
                ClassAnnotationSceneWriter.this.dynamicConstructors.put(methodDescription, this.constrs);
            }
            this.lambdas = (Set)ClassAnnotationSceneWriter.this.lambdaExpressions.get(methodDescription);
            if (this.lambdas == null) {
                this.lambdas = new TreeSet<Integer>();
                ClassAnnotationSceneWriter.this.lambdaExpressions.put(methodDescription, this.lambdas);
            }
            return new MethodCodeOffsetAdapter(ClassAnnotationSceneWriter.this.classReader, null, this.codeStart){

                @Override
                public void visitInvokeDynamicInsn(String name, String descriptor, Handle bsm, Object ... bsmArgs) {
                    String methodName = ((Handle)bsmArgs[1]).getName();
                    int off = this.getCurrentOffset();
                    if ("<init>".equals(methodName)) {
                        MethodCodeIndexer.this.constrs.add(off);
                    } else {
                        int ix = methodName.lastIndexOf(46);
                        if (ix >= 0) {
                            methodName = methodName.substring(ix + 1);
                        }
                        if (methodName.startsWith("lambda$")) {
                            MethodCodeIndexer.this.lambdas.add(off);
                        }
                    }
                    super.visitInvokeDynamicInsn(name, descriptor, bsm, bsmArgs);
                }
            };
        }
    }

    private class FieldAnnotationSceneWriter
    extends FieldVisitor {
        private final List<String> existingFieldAnnotations;
        private final AElement aField;

        public FieldAnnotationSceneWriter(int api, String name, FieldVisitor fv) {
            super(api, fv);
            this.existingFieldAnnotations = new ArrayList<String>();
            this.aField = ((ClassAnnotationSceneWriter)ClassAnnotationSceneWriter.this).aClass.fields.getVivify(name);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            this.existingFieldAnnotations.add(descriptor);
            if (this.aField.lookup(ClassAnnotationSceneWriter.classDescToName(descriptor)) != null && ClassAnnotationSceneWriter.this.overwrite) {
                return null;
            }
            return this.fv.visitAnnotation(descriptor, visible);
        }

        @Override
        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
            this.existingFieldAnnotations.add(descriptor);
            if (this.aField.lookup(ClassAnnotationSceneWriter.classDescToName(descriptor)) != null && ClassAnnotationSceneWriter.this.overwrite) {
                return null;
            }
            return this.fv.visitTypeAnnotation(typeRef, typePath, descriptor, visible);
        }

        @Override
        public void visitAttribute(Attribute attr) {
            this.fv.visitAttribute(attr);
        }

        @Override
        public void visitEnd() {
            this.ensureVisitSceneFieldAnnotations();
            this.fv.visitEnd();
        }

        private void ensureVisitSceneFieldAnnotations() {
            for (Annotation tla : this.aField.tlAnnotationsHere) {
                if (!ClassAnnotationSceneWriter.this.overwrite && this.existingFieldAnnotations.contains(ClassAnnotationSceneWriter.name(tla))) continue;
                AnnotationVisitor annotationVisitor = this.fv.visitAnnotation(ClassAnnotationSceneWriter.classNameToDesc(ClassAnnotationSceneWriter.name(tla)), ClassAnnotationSceneWriter.isRuntimeRetention(tla));
                ClassAnnotationSceneWriter.this.visitFields(annotationVisitor, tla);
                annotationVisitor.visitEnd();
            }
            TypeReference typeReference = TypeReference.newTypeReference(19);
            for (Annotation annotation : this.aField.type.tlAnnotationsHere) {
                if (!ClassAnnotationSceneWriter.this.overwrite && this.existingFieldAnnotations.contains(ClassAnnotationSceneWriter.name(annotation))) continue;
                AnnotationVisitor av = this.fv.visitTypeAnnotation(typeReference.getValue(), null, ClassAnnotationSceneWriter.classNameToDesc(ClassAnnotationSceneWriter.name(annotation)), ClassAnnotationSceneWriter.isRuntimeRetention(annotation));
                ClassAnnotationSceneWriter.this.visitFields(av, annotation);
                av.visitEnd();
            }
            for (Map.Entry entry : this.aField.type.innerTypes.entrySet()) {
                for (Annotation tla : ((ATypeElement)entry.getValue()).tlAnnotationsHere) {
                    if (!ClassAnnotationSceneWriter.this.overwrite && this.existingFieldAnnotations.contains(ClassAnnotationSceneWriter.name(tla))) continue;
                    AnnotationVisitor xav = this.fv.visitTypeAnnotation(typeReference.getValue(), TypePathEntry.listToTypePath((List)entry.getKey()), ClassAnnotationSceneWriter.classNameToDesc(ClassAnnotationSceneWriter.name(tla)), ClassAnnotationSceneWriter.isRuntimeRetention(tla));
                    ClassAnnotationSceneWriter.this.visitFields(xav, tla);
                    xav.visitEnd();
                }
            }
        }
    }

    private class MethodAnnotationSceneWriter
    extends MethodVisitor {
        private final AMethod aMethod;
        private boolean hasVisitedMethodAnnotations;
        private final List<String> existingMethodAnnotations;

        MethodAnnotationSceneWriter(int api, String name, String descriptor, MethodVisitor mv) {
            super(api, mv);
            this.hasVisitedMethodAnnotations = false;
            this.aMethod = ((ClassAnnotationSceneWriter)ClassAnnotationSceneWriter.this).aClass.methods.getVivify(name + descriptor);
            this.existingMethodAnnotations = new ArrayList<String>();
        }

        @Override
        public void visitCode() {
            super.visitCode();
        }

        @Override
        public void visitLabel(Label label) {
            super.visitLabel(label);
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            super.visitFieldInsn(opcode, owner, name, desc);
            this.track();
        }

        @Override
        public void visitIincInsn(int var, int increment) {
            super.visitIincInsn(var, increment);
            this.track();
        }

        @Override
        public void visitInsn(int opcode) {
            super.visitInsn(opcode);
            this.track();
        }

        @Override
        public void visitIntInsn(int opcode, int operand) {
            super.visitIntInsn(opcode, operand);
            this.track();
        }

        @Override
        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
            this.track();
        }

        @Override
        public void visitJumpInsn(int opcode, Label label) {
            super.visitJumpInsn(opcode, label);
            this.track();
        }

        @Override
        public void visitLdcInsn(Object cst) {
            super.visitLdcInsn(cst);
            this.track();
        }

        @Override
        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
            super.visitLookupSwitchInsn(dflt, keys, labels);
            this.track();
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            this.track();
        }

        @Override
        public void visitMultiANewArrayInsn(String desc, int dims) {
            super.visitMultiANewArrayInsn(desc, dims);
            this.track();
        }

        @Override
        public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
            super.visitTableSwitchInsn(min, max, dflt, labels);
            this.track();
        }

        @Override
        public void visitTypeInsn(int opcode, String desc) {
            super.visitTypeInsn(opcode, desc);
            this.track();
        }

        @Override
        public void visitVarInsn(int opcode, int var) {
            super.visitVarInsn(opcode, var);
            this.track();
        }

        @Override
        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            super.visitLocalVariable(name, desc, signature, start, end, index);
        }

        @Override
        public void visitEnd() {
            this.ensureVisitSceneMethodAnnotations();
            super.visitEnd();
        }

        @Override
        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            this.existingMethodAnnotations.add(descriptor);
            if (this.shouldSkipExisting(ClassAnnotationSceneWriter.classDescToName(descriptor))) {
                return null;
            }
            return super.visitAnnotation(descriptor, visible);
        }

        @Override
        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
            this.existingMethodAnnotations.add(descriptor);
            if (this.shouldSkipExisting(ClassAnnotationSceneWriter.classDescToName(descriptor))) {
                return null;
            }
            return super.visitTypeAnnotation(typeRef, typePath, descriptor, visible);
        }

        private boolean shouldSkip(Annotation tla) {
            return !ClassAnnotationSceneWriter.this.overwrite && this.existingMethodAnnotations.contains(ClassAnnotationSceneWriter.name(tla));
        }

        private boolean shouldSkipExisting(String name) {
            return !ClassAnnotationSceneWriter.this.overwrite && this.aMethod.lookup(name) != null;
        }

        private AnnotationVisitor visitAnnotation(Annotation tla) {
            return super.visitAnnotation(ClassAnnotationSceneWriter.classNameToDesc(ClassAnnotationSceneWriter.name(tla)), ClassAnnotationSceneWriter.isRuntimeRetention(tla));
        }

        private AnnotationVisitor visitTypeAnnotation(Annotation tla, TypeReference typeReference, TypePath typePath) {
            return super.visitTypeAnnotation(typeReference.getValue(), typePath, ClassAnnotationSceneWriter.classNameToDesc(ClassAnnotationSceneWriter.name(tla)), ClassAnnotationSceneWriter.isRuntimeRetention(tla));
        }

        private AnnotationVisitor visitLocalVariableAnnotation(Annotation tla, TypeReference typeReference, TypePath typePath, LocalLocation localLocation) {
            return super.visitLocalVariableAnnotation(typeReference.getValue(), typePath, localLocation.start, localLocation.end, localLocation.index, ClassAnnotationSceneWriter.classNameToDesc(ClassAnnotationSceneWriter.name(tla)), ClassAnnotationSceneWriter.isRuntimeRetention(tla));
        }

        private AnnotationVisitor visitInsnAnnotation(int typeSort, int typeIndex, Annotation tla) {
            return this.visitInsnAnnotation(typeSort, typeIndex, tla, null);
        }

        private AnnotationVisitor visitInsnAnnotation(int typeSort, int typeIndex, Annotation tla, TypePath typePath) {
            TypeReference typeReference;
            String desc = ClassAnnotationSceneWriter.classNameToDesc(ClassAnnotationSceneWriter.name(tla));
            boolean visible = ClassAnnotationSceneWriter.isRuntimeRetention(tla);
            switch (typeSort) {
                case 67: {
                    typeReference = TypeReference.newTypeReference(typeSort);
                    break;
                }
                case 68: {
                    typeReference = TypeReference.newTypeReference(typeSort);
                    break;
                }
                case 71: {
                    typeReference = TypeReference.newTypeArgumentReference(typeSort, typeIndex);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            return super.visitInsnAnnotation(typeReference.getValue(), typePath, desc, visible);
        }

        private void track() {
            this.track(67, 0, this.aMethod.body.instanceofs);
            this.track(68, 0, this.aMethod.body.news);
            for (Map.Entry entry : this.aMethod.body.typecasts.entrySet()) {
                RelativeLocation loc = (RelativeLocation)entry.getKey();
                if (!loc.isBytecodeOffset() || loc.offset != ClassAnnotationSceneWriter.this.getPreviousCodeOffset()) continue;
                this.track(71, loc.type_index, this.aMethod.body.typecasts);
            }
        }

        private void track(int typeSort, int typeIndex, Map<RelativeLocation, ATypeElement> map) {
            RelativeLocation loc = RelativeLocation.createOffset(ClassAnnotationSceneWriter.this.getPreviousCodeOffset(), typeIndex);
            ATypeElement elem = map.get(loc);
            if (elem != null) {
                for (Annotation annotation : elem.tlAnnotationsHere) {
                    this.visitInsnAnnotation(typeSort, typeIndex, annotation);
                }
                for (Map.Entry entry : elem.innerTypes.entrySet()) {
                    TypePath typePath = TypePathEntry.listToTypePath((List)entry.getKey());
                    ATypeElement inner = (ATypeElement)entry.getValue();
                    for (Annotation tla : inner.tlAnnotationsHere) {
                        this.visitInsnAnnotation(typeSort, typeIndex, tla, typePath);
                    }
                }
            }
        }

        private AnnotationVisitor visitParameterAnnotation(Annotation tla, int index) {
            return super.visitParameterAnnotation(index, ClassAnnotationSceneWriter.classNameToDesc(ClassAnnotationSceneWriter.name(tla)), ClassAnnotationSceneWriter.isRuntimeRetention(tla));
        }

        private void ensureVisitMethodDeclarationAnnotations() {
            for (Annotation tla : this.aMethod.tlAnnotationsHere) {
                if (this.shouldSkip(tla)) continue;
                AnnotationVisitor av = this.visitAnnotation(tla);
                ClassAnnotationSceneWriter.this.visitFields(av, tla);
                av.visitEnd();
            }
        }

        private void ensureVisitReturnTypeAnnotations() {
            TypeReference typeReference = TypeReference.newTypeReference(20);
            this.visitTypeAnnotationsOnTypeElement(typeReference, this.aMethod.returnType, true);
        }

        private void ensureVisitTypeParameterBoundAnnotations() {
            for (Map.Entry e : this.aMethod.bounds.entrySet()) {
                BoundLocation bloc = (BoundLocation)e.getKey();
                ATypeElement bound = (ATypeElement)e.getValue();
                TypeReference typeReference = bloc.boundIndex == -1 ? TypeReference.newTypeParameterReference(1, bloc.paramIndex) : TypeReference.newTypeParameterBoundReference(18, bloc.paramIndex, bloc.boundIndex);
                this.visitTypeAnnotationsOnTypeElement(typeReference, bound, false);
            }
        }

        private void ensureVisitLocalVariablesAnnotations() {
            TypeReference typeReference = TypeReference.newTypeReference(64);
            for (Map.Entry entry : this.aMethod.body.locals.entrySet()) {
                AnnotationVisitor xav;
                LocalLocation localLocation = (LocalLocation)entry.getKey();
                AElement aLocation = (AElement)entry.getValue();
                for (Annotation annotation : aLocation.tlAnnotationsHere) {
                    if (this.shouldSkip(annotation)) continue;
                    xav = this.visitLocalVariableAnnotation(annotation, typeReference, null, localLocation);
                    ClassAnnotationSceneWriter.this.visitFields(xav, annotation);
                    xav.visitEnd();
                }
                for (Annotation annotation : aLocation.type.tlAnnotationsHere) {
                    if (this.shouldSkip(annotation)) continue;
                    xav = this.visitLocalVariableAnnotation(annotation, typeReference, null, localLocation);
                    ClassAnnotationSceneWriter.this.visitFields(xav, annotation);
                    xav.visitEnd();
                }
                for (Map.Entry entry2 : aLocation.type.innerTypes.entrySet()) {
                    TypePath localVariableLocation = TypePathEntry.listToTypePath((List)entry2.getKey());
                    ATypeElement aInnerType = (ATypeElement)entry2.getValue();
                    for (Annotation tla : aInnerType.tlAnnotationsHere) {
                        if (this.shouldSkip(tla)) continue;
                        AnnotationVisitor xav2 = this.visitLocalVariableAnnotation(tla, typeReference, localVariableLocation, localLocation);
                        ClassAnnotationSceneWriter.this.visitFields(xav2, tla);
                        xav2.visitEnd();
                    }
                }
            }
        }

        private void ensureVisitParameterAnnotations() {
            for (Map.Entry entry : this.aMethod.parameters.entrySet()) {
                AField aParameter = (AField)entry.getValue();
                int index = (Integer)entry.getKey();
                for (Annotation tla : aParameter.tlAnnotationsHere) {
                    if (this.shouldSkip(tla)) continue;
                    AnnotationVisitor av = this.visitParameterAnnotation(tla, index);
                    ClassAnnotationSceneWriter.this.visitFields(av, tla);
                    av.visitEnd();
                }
                TypeReference typeReference = TypeReference.newFormalParameterReference(index);
                this.visitTypeAnnotationsOnTypeElement(typeReference, aParameter.type, true);
            }
        }

        private void ensureVisitReceiverAnnotations() {
            AField aReceiver = this.aMethod.receiver;
            TypeReference typeReference = TypeReference.newTypeReference(21);
            this.visitTypeAnnotationsOnTypeElement(typeReference, aReceiver.type, true);
        }

        private void ensureVisitLambdaExpressionAnnotations() {
            for (Map.Entry entry : this.aMethod.body.funs.entrySet()) {
                if (!((RelativeLocation)entry.getKey()).isBytecodeOffset()) continue;
                AMethod aLambda = (AMethod)entry.getValue();
                for (Map.Entry e0 : aLambda.parameters.entrySet()) {
                    AField aParameter = (AField)e0.getValue();
                    int index = (Integer)e0.getKey();
                    TypeReference typeReference = TypeReference.newFormalParameterReference(index);
                    for (Annotation annotation : aParameter.tlAnnotationsHere) {
                        if (this.shouldSkip(annotation)) continue;
                        AnnotationVisitor av = this.visitParameterAnnotation(annotation, index);
                        ClassAnnotationSceneWriter.this.visitFields(av, annotation);
                        av.visitEnd();
                    }
                    for (Annotation annotation : aParameter.type.tlAnnotationsHere) {
                        if (this.shouldSkip(annotation)) continue;
                        AnnotationVisitor xav = this.visitTypeAnnotation(annotation, typeReference, null);
                        ClassAnnotationSceneWriter.this.visitFields(xav, annotation);
                        xav.visitEnd();
                    }
                    for (Map.Entry entry2 : aParameter.type.innerTypes.entrySet()) {
                        TypePath aParameterLocation = TypePathEntry.listToTypePath((List)entry2.getKey());
                        ATypeElement aInnerType = (ATypeElement)entry2.getValue();
                        for (Annotation tla : aInnerType.tlAnnotationsHere) {
                            if (this.shouldSkip(tla)) continue;
                            AnnotationVisitor xav = this.visitTypeAnnotation(tla, typeReference, aParameterLocation);
                            ClassAnnotationSceneWriter.this.visitFields(xav, tla);
                            xav.visitEnd();
                        }
                    }
                }
            }
        }

        private void ensureVisitMemberReferenceAnnotations() {
            for (Map.Entry entry : this.aMethod.body.refs.entrySet()) {
                if (!((RelativeLocation)entry.getKey()).isBytecodeOffset()) continue;
                int offset = ((RelativeLocation)entry.getKey()).offset;
                int typeIndex = ((RelativeLocation)entry.getKey()).type_index;
                ATypeElement aTypeArg = (ATypeElement)entry.getValue();
                Set lset = (Set)ClassAnnotationSceneWriter.this.lambdaExpressions.get(this.aMethod.methodSignature);
                if (lset.contains(offset)) continue;
                Set cset = (Set)ClassAnnotationSceneWriter.this.dynamicConstructors.get(this.aMethod.methodSignature);
                TypeReference typeReference = cset != null && cset.contains(offset) ? TypeReference.newTypeArgumentReference(74, typeIndex) : TypeReference.newTypeArgumentReference(75, typeIndex);
                this.visitInsnAnnotationsOnTypeElement(typeReference, aTypeArg, true);
            }
        }

        private void ensureVisitMethodInvocationAnnotations() {
            for (Map.Entry entry : this.aMethod.body.calls.entrySet()) {
                if (!((RelativeLocation)entry.getKey()).isBytecodeOffset()) {
                    // empty if block
                }
                int offset = ((RelativeLocation)entry.getKey()).offset;
                int typeIndex = ((RelativeLocation)entry.getKey()).type_index;
                ATypeElement aCall = (ATypeElement)entry.getValue();
                Set cset = (Set)ClassAnnotationSceneWriter.this.dynamicConstructors.get(this.aMethod.methodSignature);
                TypeReference typeReference = cset != null && cset.contains(offset) ? TypeReference.newTypeArgumentReference(72, typeIndex) : TypeReference.newTypeArgumentReference(73, typeIndex);
                this.visitInsnAnnotationsOnTypeElement(typeReference, aCall, true);
            }
        }

        private void ensureVisitSceneMethodAnnotations() {
            if (!this.hasVisitedMethodAnnotations) {
                this.hasVisitedMethodAnnotations = true;
                this.ensureVisitMethodDeclarationAnnotations();
                this.ensureVisitReturnTypeAnnotations();
                this.ensureVisitTypeParameterBoundAnnotations();
                this.ensureVisitLocalVariablesAnnotations();
                this.ensureVisitParameterAnnotations();
                this.ensureVisitReceiverAnnotations();
                this.ensureVisitLambdaExpressionAnnotations();
                this.ensureVisitMemberReferenceAnnotations();
                this.ensureVisitMethodInvocationAnnotations();
            }
        }

        private void visitTypeAnnotationsOnTypeElement(TypeReference typeReference, ATypeElement aTypeElement, boolean maybeSkip) {
            for (Annotation tla : aTypeElement.tlAnnotationsHere) {
                if (maybeSkip && this.shouldSkip(tla)) continue;
                AnnotationVisitor av = this.visitTypeAnnotation(tla, typeReference, null);
                ClassAnnotationSceneWriter.this.visitFields(av, tla);
                av.visitEnd();
            }
            aTypeElement.innerTypes.forEach((location, innerType) -> {
                TypePath typePath = TypePathEntry.listToTypePath(location);
                for (Annotation tla : innerType.tlAnnotationsHere) {
                    if (maybeSkip && this.shouldSkip(tla)) continue;
                    AnnotationVisitor xav = this.visitTypeAnnotation(tla, typeReference, typePath);
                    ClassAnnotationSceneWriter.this.visitFields(xav, tla);
                    xav.visitEnd();
                }
            });
        }

        private void visitInsnAnnotationsOnTypeElement(TypeReference typeReference, ATypeElement aTypeElement, boolean maybeSkip) {
            for (Annotation tla : aTypeElement.tlAnnotationsHere) {
                if (maybeSkip && this.shouldSkip(tla)) continue;
                AnnotationVisitor xav = super.visitInsnAnnotation(typeReference.getValue(), null, ClassAnnotationSceneWriter.classNameToDesc(ClassAnnotationSceneWriter.name(tla)), ClassAnnotationSceneWriter.isRuntimeRetention(tla));
                ClassAnnotationSceneWriter.this.visitFields(xav, tla);
                xav.visitEnd();
            }
            aTypeElement.innerTypes.forEach((location, aInnerType) -> {
                TypePath typePath = TypePathEntry.listToTypePath(location);
                for (Annotation tla : aInnerType.tlAnnotationsHere) {
                    if (maybeSkip && this.shouldSkip(tla)) continue;
                    AnnotationVisitor xav = super.visitInsnAnnotation(typeReference.getValue(), typePath, ClassAnnotationSceneWriter.classNameToDesc(ClassAnnotationSceneWriter.name(tla)), ClassAnnotationSceneWriter.isRuntimeRetention(tla));
                    ClassAnnotationSceneWriter.this.visitFields(xav, tla);
                    xav.visitEnd();
                }
            });
        }
    }
}

