/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.annotator.find;

import java.util.List;
import org.checkerframework.afu.annotator.find.Criteria;
import org.checkerframework.afu.annotator.find.Insertion;
import org.checkerframework.afu.scenelib.type.ArrayType;
import org.checkerframework.afu.scenelib.type.BoundedType;
import org.checkerframework.afu.scenelib.type.DeclaredType;
import org.checkerframework.afu.scenelib.type.Type;

public abstract class TypedInsertion
extends Insertion {
    protected Type type;
    protected boolean annotationsOnly;
    protected List<Insertion> innerTypeInsertions;

    public TypedInsertion(Type type, Criteria criteria, List<Insertion> innerTypeInsertions) {
        this(type, criteria, false, innerTypeInsertions);
    }

    public TypedInsertion(Type type, Criteria criteria, boolean b, List<Insertion> innerTypeInsertions) {
        super(criteria, b);
        this.type = type;
        this.innerTypeInsertions = innerTypeInsertions;
        this.annotationsOnly = false;
    }

    public void setAnnotationsOnly(boolean annotationsOnly) {
        this.annotationsOnly = annotationsOnly;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public List<Insertion> getInnerTypeInsertions() {
        return this.innerTypeInsertions;
    }

    public DeclaredType getBaseType() {
        return TypedInsertion.getBaseType(this.type);
    }

    public static DeclaredType getBaseType(Type type) {
        switch (type.getKind()) {
            case DECLARED: {
                return (DeclaredType)type;
            }
            case BOUNDED: {
                return TypedInsertion.getBaseType(((BoundedType)type).getName());
            }
            case ARRAY: {
                return TypedInsertion.getBaseType(((ArrayType)type).getComponentType());
            }
        }
        return null;
    }
}

