/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.annotator.find;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import org.checkerframework.afu.annotator.Main;
import org.checkerframework.afu.annotator.find.Criteria;
import org.checkerframework.afu.annotator.find.Criterion;
import org.checkerframework.checker.interning.qual.FindDistinct;
import org.checkerframework.checker.nullness.qual.Nullable;

final class InPackageCriterion
implements Criterion {
    private final String name;

    InPackageCriterion(String name) {
        this.name = name;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.IN_PACKAGE;
    }

    @Override
    public boolean isSatisfiedBy(@Nullable TreePath path, @FindDistinct Tree leaf) {
        if (path == null) {
            return false;
        }
        assert (path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(@Nullable TreePath path) {
        if (path == null) {
            return false;
        }
        Criteria.dbug.debug("InPackageCriterion.isSatisfiedBy(%s); this=%s", Main.leafString(path), this.toString());
        do {
            Tree tree;
            if (!((tree = path.getLeaf()) instanceof CompilationUnitTree)) continue;
            CompilationUnitTree cu = (CompilationUnitTree)tree;
            ExpressionTree pn = cu.getPackageName();
            if (pn == null) {
                return this.name == null || this.name.equals("");
            }
            String packageName = pn.toString();
            return this.name != null && this.name.equals(packageName);
        } while ((path = path.getParentPath()) != null && path.getLeaf() != null);
        Criteria.dbug.debug("InPackageCriterion.isSatisfiedBy => false", new Object[0]);
        return false;
    }

    @Override
    public boolean isOnlyTypeAnnotationCriterion() {
        return false;
    }

    public String toString() {
        return "in package '" + this.name + "'";
    }
}

